%--------------------------------------------------------------------------
% File     : GEO006=Btwn3Pts-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Betweenness for 3 points on a line
% Version  : [McCharen, et al., 1976] axioms.
% English  : For any three distinct points x, y, and z, if y is between 
%            x and z, then both x is not between y and z and z is not 
%            between x and y.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T6 [McCharen, et al., 1976]
%          : t6.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   60 (   7 non-Horn)(  11 unit)
%            Number of literals          :  147 (  74 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(a_not_d,hypothesis,
    [--equal(a,d)]).

input_clause(c_not_d,hypothesis,
    [--equal(c,d)]).

input_clause(c_between_a_and_d,hypothesis,
    [++between(a,c,d)]).

input_clause(prove_not_between_others,theorem,
    [++between(c,a,d),
     ++between(a,d,c)]).
%--------------------------------------------------------------------------
