%--------------------------------------------------------------------------
% File     : GEO004=MidPtEx-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : Every line segment has a midpoint
% Version  : [Quaife, 1989] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T4 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   56 (   5 non-Horn)(   7 unit)
%            Number of literals          :  139 (  74 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :  267 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%--------------------------------------------------------------------------
input_clause(midpoint_substitution1,axiom,
    [--equal(X,Y),
     ++equal(midpoint(X,Z),midpoint(Y,Z))]).

input_clause(midpoint_substitution2,axiom,
    [--equal(X,Y),
     ++equal(midpoint(Z,X),midpoint(Z,Y))]).

input_clause(prove_midpoint,theorem,
    [--between(a,midpoint(a,b),b),
     --equidistant(a,midpoint(a,b),b,midpoint(a,b))]).
%--------------------------------------------------------------------------
