%--------------------------------------------------------------------------
% File     : GEO004=MidPtEx-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Every line segment has a midpoint
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T4 [McCharen, et al., 1976]
%          : t4.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   57 (   6 non-Horn)(   8 unit)
%            Number of literals          :  144 (  72 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :  270 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
%----Quaife states that this hypothesis is unnecessary 
input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(prove_midpoint,theorem,
    [--equidistant(a,X,b,X),
     --between(a,X,b)]).
%--------------------------------------------------------------------------
