%--------------------------------------------------------------------------
% File     : GEO003=YBtwnXY-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Geometry
% Problem  : For all points x and y, y is between x and y
% Version  : [Quaife, 1989] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
%          : Quaife A. (1989), Automated Development of Tarski's Geometry, 
%            Journal of Automated Reasoning 5(1), 97-118.
% Source   : [Quaife, 1989]
% Names    : T3 [Quaife, 1989]

% Status   : 
% Syntax   : Number of clauses           :   81 (   9 non-Horn)(  17 unit)
%            Number of literals          :  188 (  91 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :  349 (   6 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO002-0.ax').
include('Axioms/GEO002-0.eq').
%----Include definition of reflection 
include('Axioms/GEO002-2.ax').
include('Axioms/GEO002-2.eq').
%--------------------------------------------------------------------------
input_clause(d1,axiom,
    [++equidistant(U,V,U,V)]).

input_clause(d2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,U,V)]).

input_clause(d3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,W,X)]).

input_clause(d4_1,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(U,V,X,W)]).

input_clause(d4_2,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(V,U,X,W)]).

input_clause(d4_3,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(W,X,V,U)]).

input_clause(d4_4,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,U,V)]).

input_clause(d4_5,axiom,
    [--equidistant(U,V,W,X),
     ++equidistant(X,W,V,U)]).

input_clause(d5,axiom,
    [--equidistant(U,V,W,X),
     --equidistant(W,X,Y,Z),
     ++equidistant(U,V,Y,Z)]).

input_clause(e1,axiom,
    [++equal(V,extension(U,V,W,W))]).

input_clause(b0,axiom,
    [--equal(Y,extension(U,V,W,X)),
     ++between(U,V,Y)]).

input_clause(r2_1,axiom,
    [++between(U,V,reflection(U,V))]).

input_clause(r2_2,axiom,
    [++equidistant(V,reflection(U,V),U,V)]).

input_clause(r3_1,axiom,
    [--equal(U,V),
     ++equal(V,reflection(U,V))]).

input_clause(r3_2,axiom,
    [++equal(U,reflection(U,U))]).

input_clause(r4,axiom,
    [--equal(V,reflection(U,V)),
     ++equal(U,V)]).

input_clause(d7,axiom,
    [++equidistant(U,U,V,V)]).

input_clause(d8,axiom,
    [--equidistant(U,V,U1,V1),
     --equidistant(V,W,V1,W1),
     --between(U,V,W),
     --between(U1,V1,W1),
     ++equidistant(U,W,U1,W1)]).

input_clause(d9,axiom,
    [--between(U,V,W),
     --between(U,V,X),
     --equidistant(V,W,V,X),
     ++equal(U,V),
     ++equal(W,X)]).

input_clause(d10_1,axiom,
    [--between(U,V,W),
     ++equal(U,V),
     ++equal(W,extension(U,V,V,W))]).

input_clause(d10_2,axiom,
    [--equidistant(W,X,Y,Z),
     ++equal(extension(U,V,W,X),extension(U,V,Y,Z)),
     ++equal(U,V)]).

input_clause(d10_3,axiom,
    [++equal(extension(U,V,U,V),extension(U,V,V,U)),
     ++equal(U,V)]).

input_clause(r5,axiom,
    [++equidistant(V,U,V,reflection(reflection(U,V),V))]).

input_clause(r6,axiom,
    [++equal(U,reflection(reflection(U,V),V))]).

input_clause(prove_b_between_a_and_b,theorem,
    [--between(a,b,b)]).
%--------------------------------------------------------------------------
