%--------------------------------------------------------------------------
% File     : GEO001=BtwnSymm-4 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Geometry
% Problem  : Betweenness is symmetric in its outer arguments
% Version  : [McCharen, et al., 1976] axioms : Reduced > Incomplete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Symmetry of Betweenness [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   4 unit)
%            Number of literals          :   17 (   3 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   27 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
% include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
% include('Axioms/GEO001-0.ax').
% include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(identity_for_betweeness,axiom,
    [--between(X,Y,X),
     ++equal(X,Y)]).

input_clause(identity_for_equidistance,axiom,
    [--equidistant(X,Y,Z,Z),
     ++equal(X,Y)]).

input_clause(outer_pasch1,axiom,
    [--between(X,W,V),
     --between(Y,V,Z),
     ++between(X,outer_pasch(W,X,Y,Z,V),Y)]).

input_clause(outer_pasch2,axiom,
    [--between(X,W,V),
     --between(Y,V,Z),
     ++between(Z,W,outer_pasch(W,X,Y,Z,V))]).

input_clause(segment_construction1,axiom,
    [++between(X,Y,extension(X,Y,W,V))]).

input_clause(segment_construction2,axiom,
    [++equidistant(Y,extension(X,Y,W,V),W,V)]).

input_clause(b_between_a_and_c,hypothesis,
    [++between(a,b,c)]).

%----Equality substitution axioms 
input_clause(between_substitution3,axiom,
    [--equal(X,Y),
     --between(W,Z,X),
     ++between(W,Z,Y)]).

input_clause(prove_b_between_c_and_a,theorem,
    [--between(c,b,a)]).
%--------------------------------------------------------------------------
