%--------------------------------------------------------------------------
% File     : GEO001=BtwnSymm-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Geometry
% Problem  : Betweenness is symmetric in its outer arguments
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2,1-16.
%          : Schwabbauser W., Szmielew W., and Tarski A. (1983), 
%            Metamathematische Methoden in der Geometrie, Springer-Verlag, 
%            Berlin, Germany.
% Source   : [ANL]
% Names    : T1 [McCharen, et al., 1976]
%          : Theorem 5 [Overbeek, et al., 1976]
%          : t1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   57 (   6 non-Horn)(   9 unit)
%            Number of literals          :  143 (  71 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   6 constant)
%            Number of variables         :  269 (   3 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - Bug in GEO001-0.eq fixed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Tarski geometry axioms 
include('Axioms/GEO001-0.ax').
include('Axioms/GEO001-0.eq').
%--------------------------------------------------------------------------
input_clause(b_between_a_and_c,hypothesis,
    [++between(a,b,c)]).

input_clause(prove_b_between_c_and_a,theorem,
    [--between(c,b,a)]).
%--------------------------------------------------------------------------
