%--------------------------------------------------------------------------
% File     : COM004=Resolution-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Computing Theory
% Problem  : Part of completeness of resolution
% Version  : 
% English  : Part of Bundy's [1983] prrof of the completeness 
%            of resolution uses the notion of failure nodes. This proves 
%            a special case when a parent isa the empty failure node.

% Refs     : Bundy A. (1983), The Computer Modelling of Mathematical 
%            Reasoning, Academic Press.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(   9 unit)
%            Number of literals          :   51 (  28 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   52 (   1 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(make_node,axiom,
    [++failure_node(parent_of(X,Y),or(C,D)),
     --failure_node(X,or(C,P)),
     --failure_node(Y,or(D,Q)),
     --contradictory(P,Q),
     --siblings(X,Y)]).

input_clause(not_x_contradicts_x,axiom,
    [++contradictory(negate(X),X)]).

input_clause(x_contradicts_not_x,axiom,
    [++contradictory(X,negate(X))]).

input_clause(n_left_and_n_right_are_siblings,axiom,
    [++siblings(left_child_of(X),right_child_of(X))]).

%----Substitution axioms 
input_clause(left_child_of_substitution1,axiom,
    [--equal(D,E),
     ++equal(left_child_of(D),left_child_of(E))]).

input_clause(negate_substitution1,axiom,
    [--equal(F,G),
     ++equal(negate(F),negate(G))]).

input_clause(or_substitution1,axiom,
    [--equal(H,I),
     ++equal(or(H,J),or(I,J))]).

input_clause(or_substitution2,axiom,
    [--equal(K,L),
     ++equal(or(M,K),or(M,L))]).

input_clause(parent_of_substitution1,axiom,
    [--equal(N,O),
     ++equal(parent_of(N,P),parent_of(O,P))]).

input_clause(parent_of_substitution2,axiom,
    [--equal(Q,R),
     ++equal(parent_of(S,Q),parent_of(S,R))]).

input_clause(right_child_of_substitution1,axiom,
    [--equal(T,U),
     ++equal(right_child_of(T),right_child_of(U))]).

input_clause(contradictory_substitution1,axiom,
    [--equal(V,W),
     --contradictory(V,X),
     ++contradictory(W,X)]).

input_clause(contradictory_substitution2,axiom,
    [--equal(Y,Z),
     --contradictory(A1,Y),
     ++contradictory(A1,Z)]).

input_clause(failure_node_substitution1,axiom,
    [--equal(B1,C1),
     --failure_node(B1,D1),
     ++failure_node(C1,D1)]).

input_clause(failure_node_substitution2,axiom,
    [--equal(E1,F1),
     --failure_node(G1,E1),
     ++failure_node(G1,F1)]).

input_clause(siblings_substitution1,axiom,
    [--equal(H1,I1),
     --siblings(H1,J1),
     ++siblings(I1,J1)]).

input_clause(siblings_substitution2,axiom,
    [--equal(K1,L1),
     --siblings(M1,K1),
     ++siblings(M1,L1)]).

%----Stuff for the theorem 
input_clause(n_left_is_atom,hypothesis,
    [++failure_node(n_left,or(empty,atom))]).

input_clause(n_right_is_not_atom,hypothesis,
    [++failure_node(n_right,or(empty,negate(atom)))]).

input_clause(n_left_equals_left_child_of_n,hypothesis,
    [++equal(n_left,left_child_of(n))]).

input_clause(n_right_equals_right_child_of_n,hypothesis,
    [++equal(n_right,right_child_of(n))]).

%----The goal to be proved.
input_clause(goal_is_there_an_empty_node,theorem,
    [--failure_node(Z,or(empty,empty))]).
%--------------------------------------------------------------------------
