%--------------------------------------------------------------------------
% File     : COM003=Halting-2 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Computing Theory
% Problem  : The halting problem is undecidable
% Version  : [Brushi, 1991] axioms.
% English  : 

% Refs     : Burkholder L. (1987b), A 76th Automated Theorem Proving 
%            Problem, AAR newsletter 8, 6-7.
%          : Brushi M (1991), The Halting Problem, AAR newsletter 17, 
%            7-12.
% Source   : [Brushi, 1991]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   43 (   2 non-Horn)(   1 unit)
%            Number of literals          :  109 (   0 equality)
%            Number of predicate symbols :   17 (   0 propositional)
%            Number of function symbols  :   10 (   6 constant)
%            Number of variables         :  103 (  24 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Definitions of the new predicates.
% (all X (program_decides(X) <->
%         (all Y (program(Y) -> (all Z decides(X,Y,Z)))))).
input_clause(program_decides1,axiom,
    [--program_decides(X),
     --program(Y),
     ++decides(X,Y,Z)]).

input_clause(program_decides2,axiom,
    [++program_decides(X),
     ++program(f2(X))]).

input_clause(program_decides3,axiom,
    [++program_decides(X),
     --decides(X,f2(X),f1(X))]).

% (all X (program_program_decides(X) <->
%         (program(X) & program_decides(X)))).
input_clause(program_program_decides1,axiom,
    [--program_program_decides(X),
     ++program(X)]).

input_clause(program_program_decides2,axiom,
    [--program_program_decides(X),
     ++program_decides(X)]).

input_clause(program_program_decides3,axiom,
    [++program_program_decides(X),
     --program(X),
     --program_decides(X)]).

% (all X (algorithm_program_decides(X) <->
%         (algorithm(X) & program_decides(X)))).
input_clause(algorithm_program_decides1,axiom,
    [--algorithm_program_decides(X),
     ++algorithm(X)]).

input_clause(algorithm_program_decides2,axiom,
    [--algorithm_program_decides(X),
     ++program_decides(X)]).

input_clause(algorithm_program_decides3,axiom,
    [++algorithm_program_decides(X),
     --algorithm(X),
     --program_decides(X)]).

% (all X (all Y (program_halts(X,Y) <->
%                (program(X) & halts(X,Y))))).
input_clause(program_halts1,axiom,
    [--program_halts(X,Y),
     ++program(X)]).

input_clause(program_halts2,axiom,
    [--program_halts(X,Y),
     ++halts(X,Y)]).

input_clause(program_halts3,axiom,
    [++program_halts(X,Y),
     --program(X),
     --halts(X,Y)]).

% (all X (all Y (all Z (all W (halts2_outputs(X,Y,Z,W) <->
%                              (halts2(X,Y,Z) & outputs(X,W))))))).
input_clause(halts2_outputs1,axiom,
    [--halts2_outputs(X,Y,Z,W),
     ++halts2(X,Y,Z)]).

input_clause(halts2_outputs2,axiom,
    [--halts2_outputs(X,Y,Z,W),
     ++outputs(X,W)]).

input_clause(halts2_outputs3,axiom,
    [++halts2_outputs(X,Y,Z,W),
     --halts2(X,Y,Z),
     --outputs(X,W)]).

% (all X (all Y (program_not_halts(X,Y) <->
%                (program(X) & -halts(X,Y))))).
input_clause(program_not_halts1,axiom,
    [--program_not_halts(X,Y),
     ++program(X)]).

input_clause(program_not_halts2,axiom,
    [--program_not_halts(X,Y),
     --halts(X,Y)]).

input_clause(program_not_halts3,axiom,
    [++program_not_halts(X,Y),
     --program(X),
     ++halts(X,Y)]).

% (all X (all Y (all W (halts_outputs(X,Y,W) <->
%                       (halts(X,Y) & outputs(X,W)))))).
input_clause(halts_outputs1,axiom,
    [--halts_outputs(X,Y,W),
     ++halts(X,Y)]).

input_clause(halts_outputs2,axiom,
    [--halts_outputs(X,Y,W),
     ++outputs(X,W)]).

input_clause(halts_outputs3,axiom,
    [++halts_outputs(X,Y,W),
     --halts(X,Y),
     --outputs(X,W)]).

% (all X (all Y (all Z (all W (program_halts_halts2_outputs(X,Y,Z,W) <->
%                              (program_halts(Y,Z) &
%                               halts2_outputs(X,Y,Z,W))))))).
input_clause(program_halts_halts2_outputs1,axiom,
    [--program_halts_halts2_outputs(X,Y,Z,W),
     ++program_halts(Y,Z)]).

input_clause(program_halts_halts2_outputs2,axiom,
    [--program_halts_halts2_outputs(X,Y,Z,W),
     ++halts2_outputs(X,Y,Z,W)]).

input_clause(program_halts_halts2_outputs3,axiom,
    [++program_halts_halts2_outputs(X,Y,Z,W),
     --program_halts(Y,Z),
     --halts2_outputs(X,Y,Z,W)]).

% (all X (all Y (all Z (all W (program_not_halts_halts2_outputs(X,Y,Z,W) <->
%                              (program_not_halts(Y,Z) &
%                               halts2_outputs(X,Y,Z,W))))))).
input_clause(program_not_halts_halts2_outputs1,axiom,
    [--program_not_halts_halts2_outputs(X,Y,Z,W),
     ++program_not_halts(Y,Z)]).

input_clause(program_not_halts_halts2_outputs2,axiom,
    [--program_not_halts_halts2_outputs(X,Y,Z,W),
     ++halts2_outputs(X,Y,Z,W)]).

input_clause(program_not_halts_halts2_outputs3,axiom,
    [++program_not_halts_halts2_outputs(X,Y,Z,W),
     --program_not_halts(Y,Z),
     --halts2_outputs(X,Y,Z,W)]).

% (all X (all Y (all W (program_halts_halts_outputs(X,Y,W) <->
%                       (program_halts(Y,Y) & halts_outputs(X,Y,W)))))).
input_clause(program_halts_halts_outputs1,axiom,
    [--program_halts_halts_outputs(X,Y,W),
     ++program_halts(Y,Y)]).

input_clause(program_halts_halts_outputs2,axiom,
    [--program_halts_halts_outputs(X,Y,W),
     ++halts_outputs(X,Y,W)]).

input_clause(program_halts_halts_outputs3,axiom,
    [++program_halts_halts_outputs(X,Y,W),
     --program_halts(Y,Y),
     --halts_outputs(X,Y,W)]).

% (all X (all Y (all W (program_not_halts_halts_outputs(X,Y,W) <->
%                       (program_not_halts(Y,Y) & halts_outputs(X,Y,W)))))).
input_clause(program_not_halts_halts_outputs1,axiom,
    [--program_not_halts_halts_outputs(X,Y,W),
     ++program_not_halts(Y,Y)]).

input_clause(program_not_halts_halts_outputs2,axiom,
    [--program_not_halts_halts_outputs(X,Y,W),
     ++halts_outputs(X,Y,W)]).

input_clause(program_not_halts_halts_outputs3,axiom,
    [++program_not_halts_halts_outputs(X,Y,W),
     --program_not_halts(Y,Y),
     --halts_outputs(X,Y,W)]).

% New verions of the original axioms
% ((exists X algorithm_program_decides(X)) ->
%  (exists W program_program_decides(W))).
input_clause(axiom1_1,hypothesis,
    [--algorithm_program_decides(X),
     ++program_program_decides(c1)]).

% (all W (program_program_decides(W) ->
%        (all Y (all Z (program_halts_halts2_outputs(W,Y,Z,good) &
%                       program_not_halts_halts2_outputs(W,Y,Z,bad)))))).
input_clause(axiom2_1,hypothesis,
    [--program_program_decides(W),
     ++program_halts_halts2_outputs(W,Y,Z,good)]).

input_clause(axiom2_2,hypothesis,
    [--program_program_decides(W),
     ++program_not_halts_halts2_outputs(W,Y,Z,bad)]).

% ((exists W (program(W) &
%             (all Y (program_halts_halts2_outputs(W,Y,Y,good) &
%                     program_not_halts_halts2_outputs(W,Y,Y,bad))))) ->
%  (exists V (program(V) &
%             (all Y (program_halts_halts_outputs(V,Y,good) &
%                     program_not_halts_halts_outputs(V,Y,bad)))))).
input_clause(axiom3_1,hypothesis,
    [--program(W),
     --program_halts_halts2_outputs(W,f3(W),f3(W),good),
     --program_not_halts_halts2_outputs(W,f3(W),f3(W),bad),
     ++program(c2)]).

input_clause(axiom3_2,hypothesis,
    [--program(W),
     --program_halts_halts2_outputs(W,f3(W),f3(W),good),
     --program_not_halts_halts2_outputs(W,f3(W),f3(W),bad),
     ++program_halts_halts_outputs(c2,Y,good)]).

input_clause(axiom3_3,hypothesis,
    [--program(W),
     --program_halts_halts2_outputs(W,f3(W),f3(W),good),
     --program_not_halts_halts2_outputs(W,f3(W),f3(W),bad),
     ++program_not_halts_halts_outputs(c2,Y,bad)]).

% ((exists V (program(V) &
%             (all Y (program_halts_halts_outputs(V,Y,good) &
%                     program_not_halts_halts_outputs(V,Y,bad))))) ->
%  (exists U (program(U) &
%             (all Y ((program_halts(Y,Y) -> halts(U,Y)) &
%                     program_not_halts_halts_outputs(U,Y,bad)))))).
input_clause(axiom4_1,hypothesis,
    [--program(V),
     --program_halts_halts_outputs(V,f4(V),good),
     --program_not_halts_halts_outputs(V,f4(V),bad),
     ++program(c3)]).

input_clause(axiom4_2,hypothesis,
    [--program(V),
     --program_halts_halts_outputs(V,f4(V),good),
     --program_not_halts_halts_outputs(V,f4(V),bad),
     --program_halts(Y,Y),
     ++halts(c3,Y)]).

input_clause(axiom4_3,hypothesis,
    [--program(V),
     --program_halts_halts_outputs(V,f4(V),good),
     --program_not_halts_halts_outputs(V,f4(V),bad),
     ++program_not_halts_halts_outputs(c3,Y,bad)]).

%--- Prove -(exists X algorithm_program_decides(X)).
input_clause(prove_algorithm_does_not_exist,theorem,
    [++algorithm_program_decides(c4)]).
%--------------------------------------------------------------------------
