%--------------------------------------------------------------------------
% File     : COM003=Halting-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Computing Theory
% Problem  : The halting problem is undecidable
% Version  : [Burkholder, 1987b] axioms.
% English  : 

% Refs     : Burkholder L. (1987a), The halting problem, SIGCSE bulletin.
%          : Burkholder L. (1987b), A 76th Automated Theorem Proving 
%            Problem, AAR newsletter 8, 6-7.
% Source   : [Burkholder, 1987b]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   50 (  32 non-Horn)(   1 unit)
%            Number of literals          :  275 (   0 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :   12 (   6 constant)
%            Number of variables         :   98 (   7 singleton)
%            Maximal clause size         :    7
%            Maximal term depth          :    2

% Comments : 
% Bugfixes : v1.0.1 - All the axiom clauses replaced. Error due 
%            to incorrect use of formed in the conversion (my fault).
%--------------------------------------------------------------------------
% ((exists X (algorithm(X) &
%             (all Y (program(Y) ->
%                     (all Z decides(X,Y,Z)))))) ->
%  (exists W (program(W) &
%             (all Y (program(Y) ->
%                     (all Z decides(W,Y,Z))))))).
input_clause(hypothesis_1_1,hypothesis,
    [--algorithm(X),
     ++program(f2(X)),
     ++program(c1)]).

input_clause(hypothesis_1_2,hypothesis,
    [--algorithm(X),
     ++program(f2(X)),
     --program(Y),
     ++decides(c1,Y,Z)]).

input_clause(hypothesis_1_3,hypothesis,
    [--algorithm(X),
     --decides(X,f2(X),f1(X)),
     ++program(c1)]).

input_clause(hypothesis_1_4,hypothesis,
    [--algorithm(X),
     --decides(X,f2(X),f1(X)),
     --program(Y),
     ++decides(c1,Y,Z)]).

% (all W ((program(W) &
%          (all Y (program(Y) ->
%                  (all Z decides(W,Y,Z))))) ->
%         (all Y (all Z (((program(Y) &
%                          halts(Y,Z)) ->
%                         (halts2(W,Y,Z) &
%                          outputs(W,good))) &
%                        ((program(Y) &
%                          -halts(Y,Z)) ->
%                         (halts2(W,Y,Z) &
%                          outputs(W,bad)))))))).
input_clause(hypothesis_2_1,hypothesis,
    [--program(W),
     ++program(f4(W)),
     --program(Y),
     --halts(Y,Z),
     ++halts2(W,Y,Z)]).

input_clause(hypothesis_2_2,hypothesis,
    [--program(W),
     ++program(f4(W)),
     --program(Y),
     --halts(Y,Z),
     ++outputs(W,good)]).

input_clause(hypothesis_2_3,hypothesis,
    [--program(W),
     ++program(f4(W)),
     --program(Y),
     ++halts(Y,Z),
     ++halts2(W,Y,Z)]).

input_clause(hypothesis_2_4,hypothesis,
    [--program(W),
     ++program(f4(W)),
     --program(Y),
     ++halts(Y,Z),
     ++outputs(W,bad)]).

input_clause(hypothesis_2_5,hypothesis,
    [--program(W),
     --decides(W,f4(W),f3(W)),
     --program(Y),
     --halts(Y,Z),
     ++halts2(W,Y,Z)]).

input_clause(hypothesis_2_6,hypothesis,
    [--program(W),
     --decides(W,f4(W),f3(W)),
     --program(Y),
     --halts(Y,Z),
     ++outputs(W,good)]).

input_clause(hypothesis_2_7,hypothesis,
    [--program(W),
     --decides(W,f4(W),f3(W)),
     --program(Y),
     ++halts(Y,Z),
     ++halts2(W,Y,Z)]).

input_clause(hypothesis_2_8,hypothesis,
    [--program(W),
     --decides(W,f4(W),f3(W)),
     --program(Y),
     ++halts(Y,Z),
     ++outputs(W,bad)]).

% ((exists W (program(W) &
%             (all Y (((program(Y) &
%                       halts(Y,Y)) ->
%                      (halts2(W,Y,Y) &
%                       outputs(W,good))) &
%                     ((program(Y) &
%                       -halts(Y,Y)) ->
%                      (halts2(W,Y,Y) &
%                       outputs(W,bad))))))) ->
%  (exists V (program(V) &
%             (all Y (((program(Y) &
%                       halts(Y,Y)) ->
%                      (halts(V,Y) &
%                       outputs(V,good))) &
%                     ((program(Y) &
%                       -halts(Y,Y)) ->
%                      (halts(V,Y) &
%                       outputs(V,bad)))))))).
input_clause(hypothesis_3_1,hypothesis,
    [--program(W),
     ++program(f5(W)),
     ++program(c2)]).

input_clause(hypothesis_3_2,hypothesis,
    [--program(W),
     ++program(f5(W)),
     --program(Y),
     --halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_3,hypothesis,
    [--program(W),
     ++program(f5(W)),
     --program(Y),
     --halts(Y,Y),
     ++outputs(c2,good)]).

input_clause(hypothesis_3_4,hypothesis,
    [--program(W),
     ++program(f5(W)),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_5,hypothesis,
    [--program(W),
     ++program(f5(W)),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c2,bad)]).

input_clause(hypothesis_3_6,hypothesis,
    [--program(W),
     ++halts(f5(W),f5(W)),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,bad),
     ++program(c2)]).

input_clause(hypothesis_3_7,hypothesis,
    [--program(W),
     ++halts(f5(W),f5(W)),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,bad),
     --program(Y),
     --halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_8,hypothesis,
    [--program(W),
     ++halts(f5(W),f5(W)),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,bad),
     --program(Y),
     --halts(Y,Y),
     ++outputs(c2,good)]).

input_clause(hypothesis_3_9,hypothesis,
    [--program(W),
     ++halts(f5(W),f5(W)),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,bad),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_10,hypothesis,
    [--program(W),
     ++halts(f5(W),f5(W)),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,bad),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c2,bad)]).

input_clause(hypothesis_3_11,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --halts(f5(W),f5(W)),
     ++program(c2)]).

input_clause(hypothesis_3_12,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --halts(f5(W),f5(W)),
     --program(Y),
     --halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_13,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --halts(f5(W),f5(W)),
     --program(Y),
     --halts(Y,Y),
     ++outputs(c2,good)]).

input_clause(hypothesis_3_14,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --halts(f5(W),f5(W)),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_15,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --halts(f5(W),f5(W)),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c2,bad)]).

input_clause(hypothesis_3_16,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --outputs(W,bad),
     ++program(c2)]).

input_clause(hypothesis_3_17,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --outputs(W,bad),
     --program(Y),
     --halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_18,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --outputs(W,bad),
     --program(Y),
     --halts(Y,Y),
     ++outputs(c2,good)]).

input_clause(hypothesis_3_19,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --outputs(W,bad),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c2,Y)]).

input_clause(hypothesis_3_20,hypothesis,
    [--program(W),
     --halts2(W,f5(W),f5(W)),
     --outputs(W,good),
     --outputs(W,bad),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c2,bad)]).

% ((exists V (program(V) &
%             (all Y (((program(Y) &
%                       halts(Y,Y)) ->
%                      (halts(V,Y) &
%                       outputs(V,good))) &
%                     ((program(Y) &
%                       -halts(Y,Y)) ->
%                      (halts(V,Y) &
%                       outputs(V,bad))))))) ->
%  (exists U (program(U) &
%             (all Y (((program(Y) &
%                        halts(Y,Y)) ->
%                      -halts(U,Y)) &
%                     ((program(Y) &
%                       -halts(Y,Y)) ->
%                      (halts(U,Y) &
%                       outputs(U,bad)))))))).
input_clause(hypothesis_4_1,hypothesis,
    [--program(V),
     ++program(f6(V)),
     ++program(c3)]).

input_clause(hypothesis_4_2,hypothesis,
    [--program(V),
     ++program(f6(V)),
     --program(Y),
     --halts(Y,Y),
     --halts(c3,Y)]).

input_clause(hypothesis_4_3,hypothesis,
    [--program(V),
     ++program(f6(V)),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c3,Y)]).

input_clause(hypothesis_4_4,hypothesis,
    [--program(V),
     ++program(f6(V)),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c3,bad)]).

input_clause(hypothesis_4_5,hypothesis,
    [--program(V),
     ++halts(f6(V),f6(V)),
     --halts(V,f6(V)),
     --outputs(V,bad),
     ++program(c3)]).

input_clause(hypothesis_4_6,hypothesis,
    [--program(V),
     ++halts(f6(V),f6(V)),
     --halts(V,f6(V)),
     --outputs(V,bad),
     --program(Y),
     --halts(Y,Y),
     --halts(c3,Y)]).

input_clause(hypothesis_4_7,hypothesis,
    [--program(V),
     ++halts(f6(V),f6(V)),
     --halts(V,f6(V)),
     --outputs(V,bad),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c3,Y)]).

input_clause(hypothesis_4_8,hypothesis,
    [--program(V),
     ++halts(f6(V),f6(V)),
     --halts(V,f6(V)),
     --outputs(V,bad),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c3,bad)]).

input_clause(hypothesis_4_9,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --halts(f6(V),f6(V)),
     ++program(c3)]).

input_clause(hypothesis_4_10,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --halts(f6(V),f6(V)),
     --program(Y),
     --halts(Y,Y),
     --halts(c3,Y)]).

input_clause(hypothesis_4_11,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --halts(f6(V),f6(V)),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c3,Y)]).

input_clause(hypothesis_4_12,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --halts(f6(V),f6(V)),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c3,bad)]).

input_clause(hypothesis_4_13,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --outputs(V,bad),
     ++program(c3)]).

input_clause(hypothesis_4_14,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --outputs(V,bad),
     --program(Y),
     --halts(Y,Y),
     --halts(c3,Y)]).

input_clause(hypothesis_4_15,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --outputs(V,bad),
     --program(Y),
     ++halts(Y,Y),
     ++halts(c3,Y)]).

input_clause(hypothesis_4_17,hypothesis,
    [--program(V),
     --halts(V,f6(V)),
     --outputs(V,good),
     --outputs(V,bad),
     --program(Y),
     ++halts(Y,Y),
     ++outputs(c3,bad)]).

%----Prove this is impossible 
% (exists X1 (algorithm(X1) &
%             (all Y1 (program(Y1) ->
%                      (all Z1 decides(X1,Y1,Z1)))))).
input_clause(a_deciding_algorithm,theorem,
    [++algorithm(c4)]).

input_clause(prove_the_algorithm_doesnt_exist,theorem,
    [--program(Y1),
     ++decides(c4,Y1,Z1)]).
%--------------------------------------------------------------------------
