%--------------------------------------------------------------------------
% File     : COM002=8StSp-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Computing Theory
% Problem  : A program correctness theorem
% Version  : 
% English  : A computing state space, with eight states - P1 to P8. 
%            P1 leads to P3 via P2. There is a branch at P3 such that the 
%            following state is either P4 or P6. P6 leads to P8, which has 
%            a loop back to P3, while P4 leads to termination. The problem 
%            is to show that there is a loop in the computation, passing 
%            through P3.

% Refs     : Reboh R,. Raphael B., Yates R.A., Kling R.E. and 
%            Verlarde C. (1972), Study of Automatic Theorem-Proving 
%            Programs, Technical Note 72, Artificial Intelligence Centre 
%            SRI International, Menlo Park, CA.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : burstall [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   19 (   0 non-Horn)(  15 unit)
%            Number of literals          :   25 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   22 (  16 constant)
%            Number of variables         :   11 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : I suspect this problem was originally by R.M. Burstall.
%--------------------------------------------------------------------------
input_clause(direct_success,axiom,
    [++succeeds(Goal_state,Start_state),
     --follows(Goal_state,Start_state)]).

input_clause(transitivity_of_success,axiom,
    [++succeeds(Goal_state,Start_state),
     --succeeds(Goal_state,Intermediate_state),
     --succeeds(Intermediate_state,Start_state)]).

input_clause(goto_success,axiom,
    [++succeeds(Goal_state,Start_state),
     --has(Start_state,goto(Label)),
     --labels(Label,Goal_state)]).

input_clause(conditional_success,axiom,
    [++succeeds(Goal_state,Start_state),
     --has(Start_state,ifthen(Condition,Goal_state))]).

input_clause(state_1,hypothesis,
    [++has(p1,assign(register_j,0))]).

input_clause(transition_1_to_2,hypothesis,
    [++follows(p2, p1)]).

input_clause(state_2,hypothesis,
    [++has(p2,assign(register_k,1))]).

input_clause(label_state_3,hypothesis,
    [++labels(loop, p3)]).

input_clause(transition_2_to_3,hypothesis,
    [++follows(p3,p2)]).

input_clause(state_3,hypothesis,
    [++has(p3,ifthen(equal(register_j, n), p4))]).

input_clause(state_4,hypothesis,
    [++has(p4,goto(out))]).

input_clause(transition_4_to_5,hypothesis,
    [++follows(p5,p4)]).

input_clause(transition_3_to_6,hypothesis,
    [++follows(p6, p3)]).

input_clause(state_6,hypothesis,
    [++has(p6, assign(register_k,times(2, register_k)))]).

input_clause(transition_6_to_7,hypothesis,
    [++follows(p7, p6)]).

input_clause(state_7,hypothesis,
    [++has(p7, assign(register_j, plus(register_j, 1)))]).

input_clause(transition_7_to_8,hypothesis,
    [++follows(p8, p7)]).

input_clause(state_8,hypothesis,
    [++has(p8, goto(loop))]).

input_clause(prove_there_is_a_loop_through_p3,theorem,
    [--succeeds(p3,p3)]).
%--------------------------------------------------------------------------
