%--------------------------------------------------------------------------
% File     : COL066=BQW_P-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find combinator equivalent to P from B, Q and W
% Version  : [Wos & McCune, 1988] (equality) axioms.
%            Theorem formulation : The combinator is provided and checked.
% English  : Construct from B and T alone a combinator that behaves as the 
%            combinator P does, where ((Bx)y)z = x(yz), ((Qx)y)z = y(xz), 
%            (Wx)y = (xy)y, (((Px)y)y)z = (xy)((xy)z)

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
% Source   : [Wos & McCune, 1988]
% Names    : CL-7 [Wos, et al., 1990]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   5 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   6 constant)
%            Number of variables         :   26 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :   10

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(q_definition,axiom,
    [++equal(apply(apply(apply(q,X),Y),Z),apply(Y,apply(X,Z)))]).

input_clause(w_definition,axiom,
    [++equal(apply(apply(w,X),Y),apply(apply(X,Y),Y))]).

input_clause(apply_substitution1,axiom,
    [--equal(C,D),
     ++equal(apply(C,E),apply(D,E))]).

input_clause(apply_substitution2,axiom,
    [--equal(F,G),
     ++equal(apply(H,F),apply(H,G))]).

input_clause(f_substitution1,axiom,
    [--equal(I,J),
     ++equal(f(I),f(J))]).

input_clause(g_substitution1,axiom,
    [--equal(K,L),
     ++equal(g(K),g(L))]).

input_clause(h_substitution1,axiom,
    [--equal(K,L),
     ++equal(h(K),h(L))]).

input_clause(prove_p_combinator,theorem,
    [--equal(apply(apply(apply(apply(
%----This is the P equivalent
apply(apply(b,apply(w,apply(q,apply(q,q)))),q),
x),y),y),z),
apply(apply(x,y),apply(apply(x,y),z)))]).
%--------------------------------------------------------------------------
