%--------------------------------------------------------------------------
% File     : COL064=BT_V-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find combinator equivalent to V from B and T
% Version  : [Wos & McCune, 1988] (equality) axioms.
%            Theorem formulation : The combinator is provided and checked.
% English  : Construct from B and T alone a combinator that behaves as the 
%            combinator V does, where ((Bx)y)z = x(yz), (Tx)y = yx, 
%            ((Vx)y)z = (zx)y.

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
% Source   : [Wos & McCune, 1988]
% Names    : CL-5 [Wos, et al., 1990]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   4 unit)
%            Number of literals          :   19 (  19 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   23 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    9

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(t_definition,axiom,
    [++equal(apply(apply(t,X),Y),apply(Y,X))]).

input_clause(apply_substitution1,axiom,
    [--equal(C,D),
     ++equal(apply(C,E),apply(D,E))]).

input_clause(apply_substitution2,axiom,
    [--equal(F,G),
     ++equal(apply(H,F),apply(H,G))]).

input_clause(f_substitution1,axiom,
    [--equal(I,J),
     ++equal(f(I),f(J))]).

input_clause(g_substitution1,axiom,
    [--equal(K,L),
     ++equal(g(K),g(L))]).

input_clause(h_substitution1,axiom,
    [--equal(K,L),
     ++equal(h(K),h(L))]).

input_clause(prove_v_combinator,theorem,
    [--equal(apply(apply(apply(
%----This is the V equivalent
apply(apply(b,apply(t,apply(apply(b,b),t))),apply(apply(b,b),apply(
apply(b,b),t))),
x),y),z),
apply(apply(z,x),y))]).
%--------------------------------------------------------------------------
