%--------------------------------------------------------------------------
% File     : COL059=Lark2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : L3 ((lark lark) lark) is not egocentric.
% Version  : 
% English  : 

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
%          : Glickfield B., Overbeek R. (1986), A Foray into Combinatory 
%            Logic, Journal of Automated Reasoning 2(4), 419-431.
% Source   : [Glickfield & Overbeek, 1986]
% Names    : - [Glickfield & Overbeek, 1986]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   9 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   20 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%---- There exists a kestrel 
input_clause(kestrel_exists,axiom,
    [++equal(response(response(kestrel,X1),X2),X1)]).

%---- There exists a lark 
input_clause(lark_exists,axiom,
    [++equal(response(response(lark,X1),X2),response(X1,response(X2,X2)))]).

input_clause(lark_lemma1,axiom,
    [++equal(response(response(response(lark,lark),X1),X2),response(
response(X1,X1),response(X2,X2)))]).

input_clause(lark_lemma2,axiom,
    [++equal(response(response(response(response(lark,lark),lark),X1),X2),
response(response(response(X1,X1),response(X1,X1)),response(x2,x2)))]).

input_clause(lark_not_egocentric,axiom,
    [--equal(response(l2,l2),l2)]).

input_clause(l2_definition,axiom,
    [++equal(response(lark,lark),l2)]).

input_clause(l3_definition,axiom,
    [++equal(response(l2,lark),l3)]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

input_clause(prove_l3_not_egocentric,theorem,
    [++equal(response(l3,l3),l3)]).
%--------------------------------------------------------------------------
