%--------------------------------------------------------------------------
% File     : COL058=Lark1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : If there's a lark, then there's an egocentric bird.
% Version  : Theorem formulation : The egocentric bird is provided and 
%            checked.
% English  : Suppose we are given a forest that conrtains a lark, and 
%            we are not given any other information. Prove that at least 
%            one bird in the forest must be egocentric.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
%          : Glickfield B., Overbeek R. (1986), A Foray into Combinatory 
%            Logic, Journal of Automated Reasoning 2(4), 419-431.
% Source   : [Glickfield & Overbeek, 1986]
% Names    : - [Glickfield & Overbeek, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   3 unit)
%            Number of literals          :   12 (  12 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    2 (   1 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%---- There exists a lark 
input_clause(lark_exists,axiom,
    [++equal(response(response(lark,X1),X2),response(X1,response(X2,X2)))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%---- Hypothesis: This bird is egocentric 
input_clause(prove_the_bird_exists,theorem,
    [--equal(response(response(response(response(lark,lark),response(lark,
response(lark,lark))),response(lark,response(lark,lark))),response(response(
response(lark,lark),response(lark,response(lark,lark))),response(lark,
response(lark,lark)))),response(response(response(lark,lark),response(lark,
response(lark,lark))),response(lark,response(lark,lark))))]).
%--------------------------------------------------------------------------
