%--------------------------------------------------------------------------
% File     : COL057=StrongFxdPtSBCI-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Strong fixed point for S, B, C, and I
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The strong fixed point property holds for the set 
%            P consisting of the combinators S, B, C, and I, where 
%            ((Sx)y)z = (xz)(yz), ((Bx)y)z = x(yz), ((Cx)y)z = (xz)y, and 
%            Ix = x.

% Refs     : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [Lusk & Wos, 1992]
% Names    : CL5 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   25 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(c_definition,axiom,
    [++equal(apply(apply(apply(c,X),Y),Z),apply(apply(X,Z),Y))]).

input_clause(i_definition,axiom,
    [++equal(apply(i,X),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(f_substitution1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(prove_strong_fixed_point,theorem,
    [--equal(apply(Y,f(Y)),apply(f(Y),apply(Y,f(Y))))]).
%--------------------------------------------------------------------------
