%--------------------------------------------------------------------------
% File     : COL056=MBird07-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Normal Birds
% Version  : 
% English  : For all birds x and y, there exists a bird z that composes 
%            x with y for all birds w. Prove that if there exists a happy 
%            bird then there exists a normal bird.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird8.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   5 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   23 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----For all birds x and y, there exists a bird z that composes x with 
%----y for all birds w.
%----   FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))].
%----   response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,axiom,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%----Hypothesis: If there exists a happy bird then there exists a normal 
%----bird.
%----Finding clause (using xy to replace response(x,y)):
%----   -[ If TEx TEy TEz (xy = z) and (xz = y)
%----      then TEw TEv (wv = v) ].
%----   -[ FAx FAy FAz -((xy = z) and (xz = y)) | TEw TEv (wv = v) ]
%----   TEx TEy TEz [(xy = z) and (xz = y)] and FAw FAv -(wv = v).
%----   (AB = C) and (AC = B) and -(wv = v).
input_clause(a_to_b_responds_c,hypothesis,
    [++equal(response(a,b),c)]).

input_clause(a_to_c_responds_b,hypothesis,
    [++equal(response(a,c),b)]).

input_clause(prove_there_exists_a_happy_bird,theorem,
    [--equal(response(W,V),V)]).
%--------------------------------------------------------------------------
