%--------------------------------------------------------------------------
% File     : COL055=MBird06-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Happy Birds
% Version  : 
% English  : There exists a bird which is fond of some other bird. Prove 
%            that any bird that is fond of at least one bird must 
%            be happy.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird7.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   2 unit)
%            Number of literals          :   13 (  13 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(response_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(response(A,C),response(B,C))]).

input_clause(response_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(response(F,D),response(F,E))]).

%----First part of denial clause: there exists a bird which is fond 
%----of some other bird.
input_clause(fond_bird_exists,hypothesis,
    [++equal(response(a,b),b)]).

%----Hypothesis: Any bird that is fond of at least one bird must be happy.
%----  - FAx [If TEy (xy = y) then TEz TEw (xz = w) and (xw = z)].
%----  TEx -[- TEy (xy = y) | TEz TEw ((xz = w) and (xw = z))].
%----  TEx [ TEy (xy = y) and - TEz TEw ((xz = w) and (xw = z)) ].
%----  TEx [ TEy (xy = y) and FAz FAw -((xz = w) and (xw = z)) ].
%----  TEy (Ay = y) and FAz FAw -[(Az = w) and (Aw = z)].
%----  (AB = B) and [-(Az = w) | -(Aw = z)].
%----  Placing (AB = B) in the list of axiom, we have: 
input_clause(prove_happiness,theorem,
    [--equal(response(a,Z),W),
     --equal(response(a,W),Z)]).
%--------------------------------------------------------------------------
