%--------------------------------------------------------------------------
% File     : COL054=MBird05-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Compatible Birds
% Version  : 
% English  : There exists a mockingbird. For all birds x and y, there 
%            exists a bird z that composes x with y for all birds w. Prove 
%            that any two birds are compatible.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird6.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   3 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%---- There exists a mocking bird (Mock).
%----    TEx FAy [response(x,y) = response(y,y)].
%----    response(Mock,y) = response(y,y).
input_clause(mocking_bird_exists,axiom,
    [++equal(response(mocking_bird,Y),response(Y,Y))]).

%----For all birds x and y, there exists a bird z that composes x with 
%----y for all birds w.
%----   FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))].
%----   response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,hypothesis,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%----Hypothesis: Any two birds are compatible.
%----Finding clause (using xy to replace response(x,y)):
%----   -FAx FAy TEw TEz [(xw = z) and (yz = w)].
%----   TEx TEy FAw FAz -[(xw = z) and (yz = w)].
%----   Letting A = x, B = y, x = w, and y = z,
%----   -(Ax = y) | -(By = x).
input_clause(prove_birds_are_compatible,theorem,
    [--equal(response(a,X),Y),
     --equal(response(b,Y),X)]).
%--------------------------------------------------------------------------
