%--------------------------------------------------------------------------
% File     : COL053=MBird04-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : An Exercise in Composition
% Version  : 
% English  : For all birds x and y, there exists a bird z that composes 
%            x with y for all birds w. Prove that for all birds x, y, and 
%            z, there exists a bird u such that for all w, uw = x(y(zw)).

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird5.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   3 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----For all birds x and y, there exists a bird z that composes x with 
%----y for all birds w.
%----   FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))].
%----   response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,axiom,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

input_clause(f_substitutivity1,axiom,
    [--equal(G,H),
     ++equal(f(G),f(H))]).

%----Hypothesis: For all birds x, y, and z, there exists a bird u such 
%----that for all w, uw = x(y(zw)).
%----Finding clause (using xy to replace response(x,y)):
%----  - (FAx FAy FAz TEu FAw (uw = x(y(zw)))).
%----  TEx TEy TEz FAu TEw -(uw = x(y(zw))).
%----  Letting w = f(u), x = A, y = B, and z = C,
%----  -[(u)f(u) = A(B((C)f(u)))].
input_clause(prove_bird_exists,theorem,
    [--equal(response(U,f(U)),response(a,response(b,response(c,f(U)))))]).
%--------------------------------------------------------------------------
