%--------------------------------------------------------------------------
% File     : COL052=MBird03-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : A Question on Agreeable Birds
% Version  : Theorem formulation : Explicit definition of agreeable.
% English  : For all birds x and y, there exists a bird z that composes 
%            x with y for all birds w. Prove that if C is agreeable then 
%            A is agreeable.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird4.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   5 unit)
%            Number of literals          :   29 (  23 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   31 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----For all birds x and y, there exists a bird z that composes x with 
%----y for all birds w.
%----   FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))].
%----   response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,axiom,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

%----Definition of agreeable: A bird x is agreeable if and only if for all 
%----birds y there exists a bird z such that xz = yz.
%----  1) If agreeable(x) then FAy TEz [response(x,z) =
%----     response(y,z)] and
%----  2) if TEx FAy TEz [response(x,z) = response(y,z)] then
%----     agreeable(x).
%----  1) -agreeable(x) | response(x,common_bird(y)) =
%----     response(y,common_bird(y)).
%----  2) FAx TEy FAz -[response(x,z) = response(y,z)] |
%----     agreeable(x).
%----     -[response(x,z) = response(compatible(x),z)] |
%----     agreeable(x).
input_clause(agreeable1,axiom,
    [--agreeable(X),
     ++equal(response(X,common_bird(Y)),response(Y,common_bird(Y)))]).

input_clause(agreeable2,axiom,
    [--equal(response(X,Z),response(compatible(X),Z)),
     ++agreeable(X)]).

input_clause(common_bird_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(common_bird(A),common_bird(B))]).

input_clause(compatible_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(compatible(C),compatible(D))]).

input_clause(agreeable_substitutivity1,axiom,
    [--equal(Q,R),
     --agreeable(Q),
     ++agreeable(R)]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%----Hypothesis: If C is agreeable then A is agreeable.
%----   - [ If agreeable(C) then agreeable(A) ].
%----   - [ -agreeable(C) | agreeable(A) ].
%----   agreeable(C) and -agreeable(A).
input_clause(c_is_agreeable,hypothesis,
    [++agreeable(c)]).

input_clause(prove_a_is_agreeable,theorem,
    [--agreeable(a)]).

%----C composes A with B.  WHY IS THIS HERE?? 
input_clause(c_composes_a_with_b,hypothesis,
    [++equal(c,compose(a,b))]).
%--------------------------------------------------------------------------
