%--------------------------------------------------------------------------
% File     : COL052=MBird03-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : A Question on Agreeable Birds
% Version  : Theorem formulation : Implicit definition of agreeable.
% English  : For all birds x and y, there exists a bird z that composes 
%            x with y for all birds w. Prove that if C is agreeable then 
%            A is agreeable.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird4.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   5 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   25 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(common_bird_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(common_bird(A),common_bird(B))]).

%----For all birds x and y, there exists a bird z that composes x with 
%----y for all birds w.
%----   FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))].
%----   response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,axiom,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%----Hypothesis: If C is agreeable then A is agreeable.
%----   -[ If FAx TEy (response(C,y) = response(x,y)),
%----      then FAw TEv (response(A,v) = response(w,v)) ].
%----   -[ TEx FAy -(response(C,y) = response(x,y)) |
%----      FAw TEv (response(A,v) = response(w,v)) ].
%----   FAx TEy (response(C,y) = response(x,y)) and
%----      TEw FAv -(response(A,v) = response(w,v).
%----   response(C,commom_bird(x)) = response(x,common_bird(x)) and
%----      -(response(A,v) = response(odd_bird,v)).
input_clause(agreeable1,hypothesis,
    [++equal(response(c,common_bird(X)),response(X,common_bird(X)))]).

input_clause(prove_a_is_agreeable,theorem,
    [--equal(response(a,V),response(odd_bird,V))]).

%----C composes A with B. WHY is this here? 
input_clause(c_composes_a_with_b,hypothesis,
    [++equal(c,compose(a,b))]).
%--------------------------------------------------------------------------
