%--------------------------------------------------------------------------
% File     : COL051=MBird02-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Egocentric mocking bird?
% Version  : 
% English  : There exists a mocking bird. For all birds x and y, there 
%            exists a bird z that composes x with y for all birds w. Prove 
%            that there exists a bird x that is fond of itself.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York, NY, Chapter 9.
% Source   : [ANL]
% Names    : bird2.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   4 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :   23 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%---- There exists a mocking bird (Mock).
%----    TEx FAy [response(x,y) = response(y,y)].
%----    response(Mock,y) = response(y,y).
input_clause(mocking_bird_exists,axiom,
    [++equal(response(mocking_bird,Y),response(Y,Y))]).

%---- For all birds x and y, there exists a bird z that composes
%---- x with y for all birds w.
%----    FAx FAy TEz FAw [response(z,w) = response(x,response(y,w))]
%----    response(comp(x,y),w) = response(x,response(y,w)). 
input_clause(composer_exists,hypothesis,
    [++equal(response(compose(X,Y),W),response(X,response(Y,W)))]).

input_clause(compose_substitution1,axiom,
    [--equal(A,B),
     ++equal(compose(A,C),compose(B,C))]).

input_clause(compose_substitution2,axiom,
    [--equal(D,E),
     ++equal(compose(F,D),compose(F,E))]).

input_clause(response_substitution1,axiom,
    [--equal(G,H),
     ++equal(response(G,I),response(H,I))]).

input_clause(response_substitution2,axiom,
    [--equal(J,K),
     ++equal(response(L,J),response(L,K))]).

%---- Hypothesis: There exists a bird x that is fond of itself.
%----    -TEx [response(x,x) = x].
%----    FAx -[response(x,x) = x].
input_clause(prove_the_bird_exists,theorem,
    [--equal(response(X,X),X)]).
%--------------------------------------------------------------------------
