%--------------------------------------------------------------------------
% File     : COL049=StrongFxdPtBWM-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Strong fixed point for B, W, and M
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The strong fixed point property holds for the set 
%            P consisting of the combinators B, W, and M, where ((Bx)y)z 
%            = x(yz), (Wx)y = (xy)y, Mx = xx.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : McCune W.W., Wos L. (1987), A Case Study in Automated Theorem 
%            Proving: Finding Sages in Combinatory Logic, Journal 
%            of Automated Reasoning 3(1), 91-107.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Problem 2 [Wos & McCune, 1988]
%          : Overbeek Competition Eq-6 [Overbeek, 1990]
%          : CL1 [Lusk & Wos, 1992]
%          : Question 2 [Wos, 1993]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   5 unit)
%            Number of literals          :   16 (  16 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(w_definition,axiom,
    [++equal(apply(apply(w,X),Y),apply(apply(X,Y),Y))]).

input_clause(m_definition,axiom,
    [++equal(apply(m,X),apply(X,X))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(f_substitution1,axiom,
    [--equal(G,H),
     ++equal(f(G),f(H))]).

input_clause(prove_strong_fixed_point,theorem,
    [--equal(apply(Y,f(Y)),apply(f(Y),apply(Y,f(Y))))]).
%--------------------------------------------------------------------------
