%--------------------------------------------------------------------------
% File     : COL047=LQModel-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find a model for L and Q but not a strong fixed point
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The model one is seeking must satisfy L and Q and fail 
%            to satisfy the weak fixed point property, where (Lx)y 
%            = x(yy), ((Qx)y)z = y(xz).

% Refs     : Zhang J. (1992), Solution to an Open Question in Combinatory 
%            Logic, AAR Newsletter 21, p. 12.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
% Source   : [Zhang, 1992]
% Names    : Question 7 [Wos, 1993]
%          : Question 17 [Wos, 1993]

% Status   : satisfiable
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   4 unit)
%            Number of literals          :   15 (  15 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   20 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(l_definition,axiom,
    [++equal(apply(apply(l,X),Y),apply(X,apply(Y,Y)))]).

input_clause(q_definition,axiom,
    [++equal(apply(apply(apply(q,X),Y),Z),apply(Y,apply(X,Z)))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(f_substitution1,axiom,
    [--equal(G,H),
     ++equal(f(G),f(H))]).

input_clause(prove_model,theorem,
    [--equal(apply(Y,f(Y)),apply(f(Y),apply(Y,f(Y))))]).
%--------------------------------------------------------------------------
