%--------------------------------------------------------------------------
% File     : COL043=StrongFxdPtBH-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Strong fixed point for B and H
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The strong fixed point property holds for the set 
%            P consisting of the combinators B and H, where ((Bx)y)z 
%            = x(yz), ((Hx)y)z = ((xy)z)y.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : McCune W.W., Wos L. (1987), A Case Study in Automated Theorem 
%            Proving: Finding Sages in Combinatory Logic, Journal 
%            of Automated Reasoning 3(1), 91-107.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : McCune W.W. , Wos L. (1988), Some Fixed Point Problems 
%            in Combinatory Logic, AAR Newsletter 10, 7-8.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
% Source   : [McCune & Wos, 1988]
% Names    : CL4 [Lusk & Wos, 1992]
%          : Question 5 [Wos, 1993]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   4 unit)
%            Number of literals          :   15 (  15 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(h_definition,axiom,
    [++equal(apply(apply(apply(h,X),Y),Z),apply(apply(apply(X,Y),Z),Y))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(f_substitution1,axiom,
    [--equal(G,H),
     ++equal(f(G),f(H))]).

input_clause(prove_fixed_point,theorem,
    [--equal(apply(Y,f(Y)),apply(f(Y),apply(Y,f(Y))))]).
%--------------------------------------------------------------------------
