%--------------------------------------------------------------------------
% File     : COL029=StrongFxdPtU-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Strong fixed point for U
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The strong fixed point property holds for the set 
%            P consisting of the combinator U, where (Ux)y = y((xx)y).

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : McCune W.W., Wos L. (1987), A Case Study in Automated Theorem 
%            Proving: Finding Sages in Combinatory Logic, Journal 
%            of Automated Reasoning 3(1), 91-107.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : McCune W.W. , Wos L. (1988), Some Fixed Point Problems 
%            in Combinatory Logic, AAR Newsletter 10, 7-8.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
% Source   : [McCune & Wos, 1988]
% Names    : Question 1 [Wos, 1993]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   3 unit)
%            Number of literals          :   14 (  14 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :   17 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(u_definition,axiom,
    [++equal(apply(apply(u,X),Y),apply(Y,apply(apply(X,X),Y)))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(f_substitution1,axiom,
    [--equal(G,H),
     ++equal(f(G),f(H))]).

input_clause(prove_fixed_point,theorem,
    [--equal(apply(Y,f(Y)),apply(f(Y),apply(Y,f(Y))))]).
%--------------------------------------------------------------------------
