%--------------------------------------------------------------------------
% File     : COL007=WkFxdPtL-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Weak fixed point for L
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The weak fixed point property holds for the set P consisting 
%            of the combinator L, where (Lx)y = x(yy).

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : McCune W.W., Wos L. (1987), A Case Study in Automated Theorem 
%            Proving: Finding Sages in Combinatory Logic, Journal 
%            of Automated Reasoning 3(1), 91-107.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : McCune W.W. , Wos L. (1988), Some Fixed Point Problems 
%            in Combinatory Logic, AAR Newsletter 10, 7-8.
% Source   : [McCune & Wos, 1988]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   3 unit)
%            Number of literals          :   12 (  12 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(l_definition,axiom,
    [++equal(apply(apply(l,X),Y),apply(X,apply(Y,Y)))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(prove_fixed_point,theorem,
    [--equal(Y,apply(combinator,Y))]).
%--------------------------------------------------------------------------
