%--------------------------------------------------------------------------
% File     : COL005=SWModel-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find a model for S and W but not a weak fixed point
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The model one is seeking must satisfy S and W and fail 
%            to satisfy the weak fixed point property, where ((Sx)y)z 
%            = (xz)(yz), (Wx)y = (xy)y.

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : Zhang J. (1992), Solution to an Open Question in Combinatory 
%            Logic, AAR Newsletter 21, 12.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
% Source   : [Wos & McCune, 1988]
% Names    : C5 [Wos & McCune, 1988]
%          : Question 15 [Wos, 1993]

% Status   : satisfiable
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   4 unit)
%            Number of literals          :   13 (  13 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   18 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(w_definition,axiom,
    [++equal(apply(apply(w,X),Y),apply(apply(X,Y),Y))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(prove_model,theorem,
    [--equal(Y,apply(combinator,Y))]).
%--------------------------------------------------------------------------
