%--------------------------------------------------------------------------
% File     : COL004=SK_U-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find combinator equivalent to U from S and K.
% Version  : [Wos & McCune, 1988] (equality) axioms.
%            Theorem formulation : The combination is provided and 
%            checked.
% English  : Construct from S and K alone a combinator that behaves as the 
%            combinator U does, where ((Sx)y)z = (xz)(yz), (Kx)y 
%            = x, (Ux)y = y((xx)y).

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
% Source   : [Wos & McCune, 1988]
% Names    : C4 [Wos & McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   4 unit)
%            Number of literals          :   13 (  13 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   17 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :   12

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(k_definition,axiom,
    [++equal(apply(apply(k,X),Y),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(C,D),
     ++equal(apply(C,E),apply(D,E))]).

input_clause(apply_substitution2,axiom,
    [--equal(F,G),
     ++equal(apply(H,F),apply(H,G))]).

input_clause(prove_u_combinator,theorem,
    [--equal(apply(apply(
%----This is the U equivalent
apply(apply(s,apply(apply(s,apply(k,s)),k)),apply(apply(s,apply(k,apply(s,
apply(apply(s,apply(apply(s,k),k)),apply(apply(s,k),k))))),k)),
x),y),apply(y,apply(apply(x,x),y)))]).
%--------------------------------------------------------------------------
