%--------------------------------------------------------------------------
% File     : COL004=SK_U-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Find combinator equivalent to U from S and K
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : Construct from S and K alone a combinator that behaves as the 
%            combinator U does, where ((Sx)y)z = (xz)(yz), (Kx)y 
%            = x, (Ux)y = y((xx)y).

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
% Source   : [Wos & McCune, 1988]
% Names    : C4 [Wos & McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   4 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   22 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(k_definition,axiom,
    [++equal(apply(apply(k,X),Y),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(C,D),
     ++equal(apply(C,E),apply(D,E))]).

input_clause(apply_substitution2,axiom,
    [--equal(F,G),
     ++equal(apply(H,F),apply(H,G))]).

input_clause(f_substitution1,axiom,
    [--equal(I,J),
     ++equal(f(I),f(J))]).

input_clause(g_substitution1,axiom,
    [--equal(K,L),
     ++equal(g(K),g(L))]).

input_clause(prove_u_combinator,theorem,
    [--equal(apply(apply(Z,f(Z)),g(Z)),apply(g(Z),apply(apply(f(Z),f(Z)),
g(Z))))]).
%--------------------------------------------------------------------------
