%--------------------------------------------------------------------------
% File     : COL003=StrongFxdPtBW-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Strong fixed point for B and W
% Version  : [Wos & McCune, 1988] (equality) axioms.
%            Theorem formulation : The fixed point is provided and 
%            checked.
% English  : The strong fixed point property holds for the set 
%            P consisting of the combinators B and W alone, where ((Bx)y)z 
%            = x(yz) and (Wx)y = (xy)y.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : McCune W.W., Wos L. (1987), A Case Study in Automated Theorem 
%            Proving: Finding Sages in Combinatory Logic, Journal 
%            of Automated Reasoning 3(1), 91-107.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
%          : Wos L. (1993), The Kernel Strategy and its use for the Study 
%            of Combinatory Logic, Journal of Automated Reasoning 10(3), 
%            287-343.
% Source   : [TPTP]
% Names    : Question 3 [Wos, 1993]
%          : Question 5 [Wos, 1993]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   4 unit)
%            Number of literals          :   15 (  13 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   18 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : This the M sage of [McCune & Wos, 1987].
%          : fixed_point/1 substitution axioms are not included 
%            as it is simply a way of introducing the required copies 
%            of the strong fixed point.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(w_definition,axiom,
    [++equal(apply(apply(w,X),Y),apply(apply(X,Y),Y))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(strong_fixed_point,axiom,
    [--equal(apply(Strong_fixed_point,fixed_pt),apply(fixed_pt,apply(
Strong_fixed_point,fixed_pt))),
     ++fixed_point(Strong_fixed_point)]).

input_clause(prove_strong_fixed_point,theorem,
    [--fixed_point(apply(apply(b,apply(apply(b,apply(w,w)),w)),
apply(apply(b,b),b)))]).
%--------------------------------------------------------------------------
