%--------------------------------------------------------------------------
% File     : COL002=WkFxdPtSBCI-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Weak fixed point for S, B, C, and I
% Version  : [Wos & McCune, 1988] (equality) axioms.
%            Theorem formulation : The fixed point is provided and 
%            checked.
% English  : The weak fixed point property holds for the set P consisting 
%            of the combinators S, B, C, and I, where ((Sx)y)z = (xz)(yz), 
%            ((Bx)y)z = x(yz), ((Cx)y)z = (xz)y, and Ix = x.

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
% Source   : [TPTP]
% Names    : C1 [Wos & McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  15 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : This is the one found in proofs 1 and 2 of C1.1 in [Wos 
%            & McCune, 1988].
%          : fixed_point/1 substitution axioms are not included 
%            as it is simply a way of introducing the required copies.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(c_definition,axiom,
    [++equal(apply(apply(apply(c,X),Y),Z),apply(apply(X,Z),Y))]).

input_clause(i_definition,axiom,
    [++equal(apply(i,X),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(weak_fixed_point,axiom,
    [--equal(Weak_sage,apply(fixed_pt,Weak_sage)),
     ++fixed_point(Weak_sage)]).

input_clause(prove_weak_fixed_point,theorem,
    [--fixed_point(apply(apply(apply(s,apply(b,X)),i),apply(apply(s,
apply(b,X)),i)))]).
%--------------------------------------------------------------------------
