%--------------------------------------------------------------------------
% File     : COL001=WkFxdPtSK-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Weak fixed point for S and K
% Version  : [Wos & McCune, 1988] (equality) axioms : Augmented.
% English  : The weak fixed point property holds for the set P consisting 
%            of the combinators S and K alone, where ((Sx)y)z = (xz)(yz) 
%            and (Kx)y = x.

% Refs     : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
% Source   : [Wos & McCune, 1988]
% Names    : C1 [Wos & McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   7 unit)
%            Number of literals          :   16 (  16 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   23 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(k_definition,axiom,
    [++equal(apply(apply(k,X),Y),X)]).

input_clause(b_definition,axiom,
    [++equal(apply(apply(apply(b,X),Y),Z),apply(X,apply(Y,Z)))]).

input_clause(i_definition,axiom,
    [++equal(apply(i,X),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(sb_property,axiom,
    [++equal(apply(apply(apply(s,apply(b,X)),i),apply(apply(s,apply(b,X)),i)),
apply(x,apply(apply(apply(s,apply(b,X)),i),apply(apply(s,apply(b,X)),i))))]).

input_clause(prove_fixed_point,theorem,
    [--equal(Y,apply(combinator,Y))]).
%--------------------------------------------------------------------------
