%--------------------------------------------------------------------------
% File     : COL001=WkFxdPtSK-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Combinatory Logic
% Problem  : Weak fixed point for S and K
% Version  : [Wos & McCune, 1988] (equality) axioms.
% English  : The weak fixed point property holds for the set P consisting 
%            of the combinators S and K alone, where ((Sx)y)z = (xz)(yz) 
%            and (Kx)y = x.

% Refs     : Smullyan, R. M. (1985), To Mock a Mocking Bird and Other 
%            Logic Puzzles, Knopf, New York.
%          : Wos L., McCune W.W (1988), Challenge Problems Focusing 
%            on Equality and Combinatory Logic: Evaluating Automated 
%            Theorem-Proving Programs, Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 714-729.
% Source   : [Wos & McCune, 1988]
% Names    : C1 [Wos & McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   4 unit)
%            Number of literals          :   13 (  13 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   18 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(s_definition,axiom,
    [++equal(apply(apply(apply(s,X),Y),Z),apply(apply(X,Z),apply(Y,Z)))]).

input_clause(k_definition,axiom,
    [++equal(apply(apply(k,X),Y),X)]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(prove_fixed_point,theorem,
    [--equal(Y,apply(combinator,Y))]).
%--------------------------------------------------------------------------
