%--------------------------------------------------------------------------
% File     : CIV003=Adder1-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Circuit Verification
% Problem  : One bit Full Adder
% Version  : [Wos, et al., 1992] axioms.
% English  : 

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated 
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [Wos, et al., 1992]
% Names    : - [Wos, et al., 1992]

% Status   : 
% Syntax   : Number of clauses           :   65 (   0 non-Horn)(  48 unit)
%            Number of literals          :   85 (  79 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   20 (  14 constant)
%            Number of variables         :  125 (  14 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include definitions of AND, OR and NOT 
include('Axioms/CID002-0.ax').
%----Include substitution axioms for AND, OR and NOT 
include('Axioms/CID001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(carryout_substitution1,axiom,
    [--equal(A,B),
     ++equal(carryout(A,C,D),carryout(B,C,D))]).

input_clause(carryout_substitution2,axiom,
    [--equal(E,F),
     ++equal(carryout(G,E,H),carryout(G,F,H))]).

input_clause(carryout_substitution3,axiom,
    [--equal(I,J),
     ++equal(carryout(K,L,I),carryout(K,L,J))]).

input_clause(sum_substitution1,axiom,
    [--equal(M,N),
     ++equal(sum(M,O,P),sum(N,O,P))]).

input_clause(sum_substitution2,axiom,
    [--equal(Q,R),
     ++equal(sum(S,Q,T),sum(S,R,T))]).

input_clause(sum_substitution3,axiom,
    [--equal(U,V),
     ++equal(sum(W,X,U),sum(W,X,V))]).

input_clause(xor_substitution1,axiom,
    [--equal(Y,Z),
     ++equal(xor(Y,A1),xor(Z,A1))]).

input_clause(xor_substitution2,axiom,
    [--equal(B1,C1),
     ++equal(xor(D1,B1),xor(D1,C1))]).

input_clause(circuit_substitution1,axiom,
    [--equal(E1,F1),
     --circuit(E1,G1),
     ++circuit(F1,G1)]).

input_clause(circuit_substitution2,axiom,
    [--equal(H1,I1),
     --circuit(J1,H1),
     ++circuit(J1,I1)]).

%----Simplifiers 
input_clause(demorgan1,axiom,
    [++equal(not(and(X,Y)),or(not(X),not(Y)))]).

input_clause(demorgan2,axiom,
    [++equal(not(or(X,Y)),and(not(X),not(Y)))]).

input_clause(not_involution,axiom,
    [++equal(not(not(X)),X)]).

input_clause(and_symmetry,theorem,
    [++equal(and(X,Y),and(Y,X))]).

input_clause(or_symmetry,theorem,
    [++equal(or(X,Y),or(Y,X))]).

input_clause(and_or_simplification,theorem,
    [++equal(and(or(X,Y),Z),or(and(X,Z),and(Y,Z)))]).

input_clause(and_commutativity,theorem,
    [++equal(and(and(X,Y),Z),and(and(X,Z),Y))]).

input_clause(or_commutativity,theorem,
    [++equal(or(or(X,Y),Z),or(or(X,Z),Y))]).

%----Evaluators 
input_clause(and_not_evaluation1,axiom,
    [++equal(and(X,not(X)),0)]).

input_clause(or_not_evaluation1,axiom,
    [++equal(or(X,not(X)),1)]).

input_clause(and_idempotency,axiom,
    [++equal(and(X,X),X)]).

input_clause(or_idempotency,axiom,
    [++equal(or(X,X),X)]).

%----Evaluators of lists of 3 terms 
input_clause(and_not_evaluation2,axiom,
    [++equal(and(and(X,Y),not(Y)),0)]).

input_clause(and_not_evaluation3,axiom,
    [++equal(and(and(X,Y),not(X)),0)]).

input_clause(or_not_evaluation2,axiom,
    [++equal(or(or(X,Y),not(Y)),1)]).

input_clause(or_not_evaluation3,axiom,
    [++equal(or(or(X,Y),not(X)),1)]).

input_clause(and_evaluation1,axiom,
    [++equal(and(and(X,Y),Y),and(X,Y))]).

input_clause(or_evaluation1,axiom,
    [++equal(or(or(X,Y),Y),or(X,Y))]).

%----Simplifiers for products of 4 terms 
input_clause(and_not_evaluation4,axiom,
    [++equal(and(and(and(X1,X2),X3),not(X1)),0)]).

input_clause(and_not_evaluation5,axiom,
    [++equal(and(and(and(X1,X2),X3),not(X2)),0)]).

%----Subsumption type demodulators 
input_clause(and_or_subsumption1,axiom,
    [++equal(or(and(X,Y),Y),Y)]).

input_clause(and_or_subsumption2,axiom,
    [++equal(or(and(X,Y),X),X)]).

input_clause(and_or_subsumption3,axiom,
    [++equal(or(or(and(X,Y),Z),Y),or(Z,Y))]).

input_clause(and_or_subsumption4,axiom,
    [++equal(or(or(X,and(Y,Z)),Z),or(X,Z))]).

%----Karnaugh map technique 
input_clause(karnaugh1,axiom,
    [++equal(or(and(X,not(Y)),Y),or(X,Y))]).

input_clause(karnaugh2,axiom,
    [++equal(or(and(not(X),not(Y)),Y),or(Y,not(X)))]).

%----Karnaugh simplifier of inside product 
input_clause(karnaugh3,axiom,
    [++equal(or(and(and(X,Y),not(Z)),and(X,Z)),or(and(X,Y),and(X,Z)))]).

%----Circuit description 
input_clause(xor_definition,axiom,
    [++equal(xor(X,Y),or(and(X,not(Y)),and(Y,not(X))))]).

input_clause(carryout_definition,theorem,
    [++equal(carryout(X,Y,Z),or(and(X,or(Y,Z)),and(not(X),and(Y,Z))))]).

input_clause(sum_definition,theorem,
    [++equal(sum(X,Y,Z),xor(xor(X,Y),Z))]).

input_clause(circuit1,theorem,
    [++equal(a11,not(and(a,b)))]).

input_clause(circuit2,theorem,
    [++equal(a12,not(and(a11,a)))]).

input_clause(circuit3,theorem,
    [++equal(a13,not(and(a11,b)))]).

input_clause(circuit4,theorem,
    [++equal(a14,not(and(a12,a13)))]).

input_clause(circuit5,theorem,
    [++equal(a15,not(and(a14,carryin)))]).

input_clause(circuit6,theorem,
    [++equal(a16,not(and(a14,a15)))]).

input_clause(circuit7,theorem,
    [++equal(a17,not(and(a15,carryin)))]).

input_clause(circuit8,theorem,
    [++equal(s1,not(and(a16,a17)))]).

input_clause(circuit9,theorem,
    [++equal(c1,not(and(a11,a15)))]).

input_clause(the_output_circuit,theorem,
    [++circuit(s1,c1)]).

input_clause(prove_circuit,theorem,
    [--circuit(sum(a,b,carryin),carryout(a,b,carryin))]).
%--------------------------------------------------------------------------
