%--------------------------------------------------------------------------
% File     : CIV002=TwoInv-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Circuit Verification
% Problem  : Invert 3 inputs with 2 not gates
% Version  : [ANL] axioms : Reduced > Complete.
% English  : This is made to validate the circuit that inverts 3 inputs 
%            using as many AND and OR gates as you like, but using only 
%            two NOT gates.

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated 
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : two.inverter.val.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   62 (   0 non-Horn)(  51 unit)
%            Number of literals          :   76 (  68 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   39 (  35 constant)
%            Number of variables         :   56 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : Some duplicate clauses have been removed from the [ANL] 
%            version.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include substitution axioms for AND, OR and NOT 
include('Axioms/CID001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(xor_substitution1,axiom,
    [--equal(O,P),
     ++equal(xor(O,Q),xor(P,Q))]).

input_clause(xor_substitution2,axiom,
    [--equal(R,S),
     ++equal(xor(T,R),xor(T,S))]).

input_clause(circuit_substitution1,axiom,
    [--equal(U,V),
     --circuit(U),
     ++circuit(V)]).

%----Canonicalizing an exclusive-or/and expression 
input_clause(xor_definition1,axiom,
    [++equal(xor(0,X),X)]).

input_clause(xor_definition2,axiom,
    [++equal(xor(X,0),X)]).

input_clause(xor_definition3,axiom,
    [++equal(xor(X,X),0)]).

input_clause(xor_simplification1,axiom,
    [++equal(xor(X,xor(X,Y)),Y)]).

input_clause(and_definition1,axiom,
    [++equal(and(0,X),0)]).

input_clause(and_definition2,axiom,
    [++equal(and(X,0),0)]).

input_clause(and_definition3,axiom,
    [++equal(and(1,X),X)]).

input_clause(and_definition4,axiom,
    [++equal(and(X,1),X)]).

input_clause(and_simplification1,axiom,
    [++equal(and(X,X),X)]).

input_clause(and_simplification2,axiom,
    [++equal(and(X,and(X,Y)),and(X,Y))]).

input_clause(and_xor_simplification,axiom,
    [++equal(and(X,xor(Y,Z)),xor(and(X,Y),and(X,Z)))]).

input_clause(not_to_xor,axiom,
    [++equal(not(X),xor(1,X))]).

input_clause(or_to_xor,axiom,
    [++equal(or(X,Y),xor(and(X,Y),xor(X,Y)))]).

%----Associativity and symmetry 
input_clause(xor_symmetry,theorem,
    [++equal(xor(X,Y),xor(Y,X))]).

input_clause(xor_commutativity,theorem,
    [++equal(xor(Y,xor(X,Z)),xor(X,xor(Y,Z)))]).

input_clause(and_symmetry,theorem,
    [++equal(and(X,Y),and(Y,X))]).

input_clause(and_commutativity,theorem,
    [++equal(and(Y,and(X,Z)),and(X,and(Y,Z)))]).

%----Problem clauses 
input_clause(constructor1,theorem,
    [++equal(o1,13)]).

input_clause(constructor2,theorem,
    [++equal(o2,17)]).

input_clause(constructor3,theorem,
    [++equal(o3,5)]).

input_clause(constructor4,theorem,
    [++equal(a1,and(inv1,i2))]).

input_clause(constructor5,theorem,
    [++equal(2,and(inv1,i3))]).

input_clause(constructor6,theorem,
    [++equal(3,or(a1,24))]).

input_clause(constructor7,theorem,
    [++equal(4,or(15,3))]).

input_clause(constructor8,theorem,
    [++equal(5,or(4,21))]).

input_clause(constructor9,theorem,
    [++equal(6,and(i1,i2))]).

input_clause(constructor10,theorem,
    [++equal(7,and(6,i3))]).

input_clause(constructor11,theorem,
    [++equal(8,or(a1,10))]).

input_clause(constructor12,theorem,
    [++equal(9,or(8,2))]).

input_clause(constructor13,theorem,
    [++equal(10,or(24,7))]).

input_clause(constructor14,theorem,
    [++equal(11,or(a1,2))]).

input_clause(constructor15,theorem,
    [++equal(12,or(11,16))]).

input_clause(constructor16,theorem,
    [++equal(13,or(12,21))]).

input_clause(constructor17,theorem,
    [++equal(14,and(i2,i3))]).

input_clause(constructor18,theorem,
    [++equal(15,and(inv2,6))]).

input_clause(constructor19,theorem,
    [++equal(16,and(14,inv2))]).

input_clause(constructor20,theorem,
    [++equal(17,or(18,21))]).

input_clause(constructor21,theorem,
    [++equal(18,or(19,25))]).

input_clause(constructor22,theorem,
    [++equal(19,and(23,inv2))]).

input_clause(constructor23,theorem,
    [++equal(20,or(22,14))]).

input_clause(constructor24,theorem,
    [++equal(21,and(inv1,inv2))]).

input_clause(constructor25,theorem,
    [++equal(22,or(23,6))]).

input_clause(constructor26,theorem,
    [++equal(23,and(i1,i3))]).

input_clause(constructor27,theorem,
    [++equal(24,and(i1,inv1))]).

input_clause(constructor28,theorem,
    [++equal(25,or(2,24))]).

input_clause(constructor29,theorem,
    [++equal(inv1,not(20))]).

input_clause(constructor30,theorem,
    [++equal(inv2,not(9))]).

input_clause(output1,theorem,
    [++circuit(o1)]).

input_clause(output2,theorem,
    [++circuit(o2)]).

input_clause(output3,theorem,
    [++circuit(o3)]).

input_clause(prove_inversion,theorem,
    [--circuit(not(i1)),
     --circuit(not(i2)),
     --circuit(not(i3))]).
%--------------------------------------------------------------------------
