%--------------------------------------------------------------------------
% File     : CIV001=Intchg-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Circuit Verification
% Problem  : Interchange inputs to outputs
% Version  : 
% English  : This validates one of the circuit designs that will take 
%            x and y as input and output y and x without crossing any 
%            wires.

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated 
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : - [Wos, et al., 1992]
%          : intchg_val.ver1.clauses [ANL]

% Status   : 
% Syntax   : Number of clauses           :   61 (   0 non-Horn)(  48 unit)
%            Number of literals          :   77 (  71 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   24 (  19 constant)
%            Number of variables         :   90 (   6 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : See CID002-1 for the design problem.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include definitions of AND, OR and NOT 
include('Axioms/CID002-0.ax').
%----Include substitution axioms for AND, OR and NOT 
include('Axioms/CID001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(input_substitution1,axiom,
    [--equal(A,B),
     ++equal(input(A,C),input(B,C))]).

input_clause(input_substitution2,axiom,
    [--equal(D,E),
     ++equal(input(F,D),input(F,E))]).

input_clause(output_substitution1,axiom,
    [--equal(G,H),
     ++equal(output(G,I),output(H,I))]).

input_clause(output_substitution2,axiom,
    [--equal(J,K),
     ++equal(output(L,J),output(L,K))]).

input_clause(circuit_substitution1,axiom,
    [--equal(M,N),
     --circuit(M,O),
     ++circuit(N,O)]).

input_clause(circuit_substitution2,axiom,
    [--equal(P,Q),
     --circuit(R,P),
     ++circuit(R,Q)]).

%----Commutativity and associativity 
input_clause(and_commutativity,axiom,
    [++equal(and(X,Y),and(Y,X))]).

input_clause(or_commutativity,axiom,
    [++equal(or(X,Y),or(Y,X))]).

input_clause(and_associativity,axiom,
    [++equal(and(X,and(Y,Z)),and(and(X,Y),Z))]).

input_clause(or_associativity,axiom,
    [++equal(or(X,or(Y,Z)),or(or(X,Y),Z))]).

%----Sorting 
input_clause(or_sorting,axiom,
    [++equal(or(or(X,Y),Z),or(or(X,Z),Y))]).

input_clause(and_sorting,axiom,
    [++equal(and(and(X,Y),Z),and(and(X,Z),Y))]).

%----Canonicalization to move Not to inside 
input_clause(not_canonicalization1,axiom,
    [++equal(not(and(X,Y)),or(not(X),not(Y)))]).

input_clause(not_canonicalization2,axiom,
    [++equal(not(or(X,Y)),and(not(X),not(Y)))]).

%----Canonicalization to sum-of-products 
input_clause(and_or_canonicalization,axiom,
    [++equal(and(or(X,Y),Z),or(and(X,Z),and(Y,Z)))]).

%----Simplifiers 
input_clause(and_simplification1,axiom,
    [++equal(and(X,X),X)]).

input_clause(and_simplification2,axiom,
    [++equal(and(and(X,Y),Y),and(X,Y))]).

input_clause(and_simplification3,axiom,
    [++equal(and(and(X,Y),X),and(X,Y))]).

input_clause(or_simplification1,axiom,
    [++equal(or(X,X),X)]).

input_clause(or_simplification2,axiom,
    [++equal(or(or(X,Y),Y),or(X,Y))]).

input_clause(or_simplification3,axiom,
    [++equal(or(or(X,Y),X),or(X,Y))]).

input_clause(and_not_simplification1,axiom,
    [++equal(and(X,not(X)),0)]).

input_clause(and_not_simplification2,axiom,
    [++equal(and(and(X,Y),not(Y)),0)]).

input_clause(and_not_simplification3,axiom,
    [++equal(and(and(X,Y),not(X)),0)]).

input_clause(or_not_simplification1,axiom,
    [++equal(or(X,not(X)),1)]).

input_clause(or_not_simplification2,axiom,
    [++equal(or(or(X,Y),not(Y)),1)]).

input_clause(or_not_simplification3,axiom,
    [++equal(or(or(X,Y),not(X)),1)]).

input_clause(not_simplification,axiom,
    [++equal(not(not(X)),X)]).

input_clause(and_or_not_simplification1,axiom,
    [++equal(or(and(X,Y),and(X,not(Y))),X)]).

input_clause(and_or_not_simplification2,axiom,
    [++equal(or(and(X,Y),and(Y,not(X))),Y)]).

%----Theorem clauses 
input_clause(constructor1,theorem,
    [++equal(a1,and(b1,b3))]).

input_clause(constructor2,theorem,
    [++equal(a2,and(b2,b3))]).

input_clause(constructor3,theorem,
    [++equal(b1,not(d1))]).

input_clause(constructor4,theorem,
    [++equal(b2,not(d2))]).

input_clause(constructor5,theorem,
    [++equal(b3,or(c1,c2))]).

input_clause(constructor6,theorem,
    [++equal(c1,or(d1,d3))]).

input_clause(constructor7,theorem,
    [++equal(c2,or(d2,d3))]).

input_clause(constructor8,theorem,
    [++equal(d3,f3)]).

input_clause(constructor9,theorem,
    [++equal(d1,not(e1))]).

input_clause(constructor10,theorem,
    [++equal(d2,not(e2))]).

input_clause(constructor11,theorem,
    [++equal(e1,or(f1,f3))]).

input_clause(constructor12,theorem,
    [++equal(e2,or(f2,f3))]).

input_clause(constructor13,theorem,
    [++equal(f1,not(i1))]).

input_clause(constructor14,theorem,
    [++equal(f2,not(i2))]).

input_clause(constructor15,theorem,
    [++equal(f3,and(i1,i2))]).

input_clause(circuit_description,theorem,
    [++circuit(input(i1,i2),output(a1,a2))]).

input_clause(prove_interchange,theorem,
    [--circuit(input(i1,i2),output(i2,i1))]).
%--------------------------------------------------------------------------
