%--------------------------------------------------------------------------
% File     : CID003=TwoInv-2 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Circuit Design
% Problem  : Invert 3 inputs with 2 not gates
% Version  : [Wos, et al., 1992] axioms.
% English  : 

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : two.inverter.ver2.in [ANL]
%          : - [Wos, et al., 1992]

% Status   : 
% Syntax   : Number of clauses           :   79 (   0 non-Horn)(  20 unit)
%            Number of literals          :  170 (  96 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   25 (  16 constant)
%            Number of variables         :  509 (   9 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :   14

% Comments : The original uses the equality axioms as demodulators.
%--------------------------------------------------------------------------
%----Include axioms of equality
include('Axioms/EQU001-0.ax').
%----Include definitions of AND, OR and NOT
include('Axioms/CID002-0.ax').
%----Include substitution axioms for AND, OR and NOT
include('Axioms/CID001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms
input_clause(add_inverter_substitution1,axiom,
    [--equal(D,E),
     ++equal(add_inverter(D,F),add_inverter(E,F))]).

input_clause(add_inverter_substitution2,axiom,
    [--equal(G,H),
     ++equal(add_inverter(I,G),add_inverter(I,H))]).

input_clause(inverter_table_substitution1,axiom,
    [--equal(P,Q),
     ++equal(inverter_table(P,R,S,T,U,V,W,X),
inverter_table(Q,R,S,T,U,V,W,X))]).

input_clause(inverter_table_substitution2,axiom,
    [--equal(Y,Z),
     ++equal(inverter_table(A1,Y,B1,C1,D1,E1,F1,G1),
inverter_table(A1,Z,B1,C1,D1,E1,F1,G1))]).

input_clause(inverter_table_substitution3,axiom,
    [--equal(H1,I1),
     ++equal(inverter_table(J1,K1,H1,L1,M1,N1,O1,P1),
inverter_table(J1,K1,I1,L1,M1,N1,O1,P1))]).

input_clause(inverter_table_substitution4,axiom,
    [--equal(Q1,R1),
     ++equal(inverter_table(S1,T1,U1,Q1,V1,W1,X1,Y1),
inverter_table(S1,T1,U1,R1,V1,W1,X1,Y1))]).

input_clause(inverter_table_substitution5,axiom,
    [--equal(Z1,A2),
     ++equal(inverter_table(B2,C2,D2,E2,Z1,F2,G2,H2),
inverter_table(B2,C2,D2,E2,A2,F2,G2,H2))]).

input_clause(inverter_table_substitution6,axiom,
    [--equal(I2,J2),
     ++equal(inverter_table(K2,L2,M2,N2,O2,I2,P2,Q2),
inverter_table(K2,L2,M2,N2,O2,J2,P2,Q2))]).

input_clause(inverter_table_substitution7,axiom,
    [--equal(R2,S2),
     ++equal(inverter_table(T2,U2,V2,W2,X2,Y2,R2,Z2),
inverter_table(T2,U2,V2,W2,X2,Y2,S2,Z2))]).

input_clause(inverter_table_substitution8,axiom,
    [--equal(A3,B3),
     ++equal(inverter_table(C3,D3,E3,F3,G3,H3,I3,A3),
inverter_table(C3,D3,E3,F3,G3,H3,I3,B3))]).

input_clause(list_substitution1,axiom,
    [--equal(J3,K3),
     ++equal(list(J3,L3),list(K3,L3))]).

input_clause(list_substitution2,axiom,
    [--equal(M3,N3),
     ++equal(list(O3,M3),list(O3,N3))]).

input_clause(list_reversion_substitution1,axiom,
    [--equal(P3,Q3),
     ++equal(list_reversion(P3,R3),list_reversion(Q3,R3))]).

input_clause(list_reversion_substitution2,axiom,
    [--equal(S3,T3),
     ++equal(list_reversion(U3,S3),list_reversion(U3,T3))]).

input_clause(make_reverse_list_substitution1,axiom,
    [--equal(V3,W3),
     ++equal(make_reverse_list(V3),make_reverse_list(W3))]).

input_clause(possible_reversion_substitution1,axiom,
    [--equal(F4,G4),
     ++equal(possible_reversion(F4,H4,I4),possible_reversion(G4,H4,I4))]).

input_clause(possible_reversion_substitution2,axiom,
    [--equal(J4,K4),
     ++equal(possible_reversion(L4,J4,M4),possible_reversion(L4,K4,M4))]).

input_clause(possible_reversion_substitution3,axiom,
    [--equal(N4,O4),
     ++equal(possible_reversion(P4,Q4,N4),possible_reversion(P4,Q4,O4))]).

input_clause(basic_output_substitution1,axiom,
    [--equal(R4,S4),
     --basic_output(R4,T4,U4,V4,W4,X4,Y4,Z4,A5),
     ++basic_output(S4,T4,U4,V4,W4,X4,Y4,Z4,A5)]).

input_clause(basic_output_substitution2,axiom,
    [--equal(B5,C5),
     --basic_output(D5,B5,E5,F5,G5,H5,I5,J5,K5),
     ++basic_output(D5,C5,E5,F5,G5,H5,I5,J5,K5)]).

input_clause(basic_output_substitution3,axiom,
    [--equal(L5,M5),
     --basic_output(N5,O5,L5,P5,Q5,R5,S5,T5,U5),
     ++basic_output(N5,O5,M5,P5,Q5,R5,S5,T5,U5)]).

input_clause(basic_output_substitution4,axiom,
    [--equal(V5,W5),
     --basic_output(X5,Y5,Z5,V5,A6,B6,C6,D6,E6),
     ++basic_output(X5,Y5,Z5,W5,A6,B6,C6,D6,E6)]).

input_clause(basic_output_substitution5,axiom,
    [--equal(F6,G6),
     --basic_output(H6,I6,J6,K6,F6,L6,M6,N6,O6),
     ++basic_output(H6,I6,J6,K6,G6,L6,M6,N6,O6)]).

input_clause(basic_output_substitution6,axiom,
    [--equal(P6,Q6),
     --basic_output(R6,S6,T6,U6,V6,P6,W6,X6,Y6),
     ++basic_output(R6,S6,T6,U6,V6,Q6,W6,X6,Y6)]).

input_clause(basic_output_substitution7,axiom,
    [--equal(Z6,A7),
     --basic_output(B7,C7,D7,E7,F7,G7,Z6,H7,I7),
     ++basic_output(B7,C7,D7,E7,F7,G7,A7,H7,I7)]).

input_clause(basic_output_substitution8,axiom,
    [--equal(J7,K7),
     --basic_output(L7,M7,N7,O7,P7,Q7,R7,J7,S7),
     ++basic_output(L7,M7,N7,O7,P7,Q7,R7,K7,S7)]).

input_clause(basic_output_substitution9,axiom,
    [--equal(T7,U7),
     --basic_output(V7,W7,X7,Y7,Z7,A8,B8,C8,T7),
     ++basic_output(V7,W7,X7,Y7,Z7,A8,B8,C8,U7)]).

input_clause(output_substitution1,axiom,
    [--equal(D8,E8),
     --output(D8,F8,G8,H8,I8,J8,K8,L8,M8),
     ++output(E8,F8,G8,H8,I8,J8,K8,L8,M8)]).

input_clause(output_substitution2,axiom,
    [--equal(N8,O8),
     --output(P8,N8,Q8,R8,S8,T8,U8,V8,W8),
     ++output(P8,O8,Q8,R8,S8,T8,U8,V8,W8)]).

input_clause(output_substitution3,axiom,
    [--equal(X8,Y8),
     --output(Z8,A9,X8,B9,C9,D9,E9,F9,G9),
     ++output(Z8,A9,Y8,B9,C9,D9,E9,F9,G9)]).

input_clause(output_substitution4,axiom,
    [--equal(H9,I9),
     --output(J9,K9,L9,H9,M9,N9,O9,P9,Q9),
     ++output(J9,K9,L9,I9,M9,N9,O9,P9,Q9)]).

input_clause(output_substitution5,axiom,
    [--equal(R9,S9),
     --output(T9,U9,V9,W9,R9,X9,Y9,Z9,A10),
     ++output(T9,U9,V9,W9,S9,X9,Y9,Z9,A10)]).

input_clause(output_substitution6,axiom,
    [--equal(B10,C10),
     --output(D10,E10,F10,G10,H10,B10,I10,J10,K10),
     ++output(D10,E10,F10,G10,H10,C10,I10,J10,K10)]).

input_clause(output_substitution7,axiom,
    [--equal(L10,M10),
     --output(N10,O10,P10,Q10,R10,S10,L10,T10,U10),
     ++output(N10,O10,P10,Q10,R10,S10,M10,T10,U10)]).

input_clause(output_substitution8,axiom,
    [--equal(V10,W10),
     --output(X10,Y10,Z10,A11,B11,C11,D11,V10,E11),
     ++output(X10,Y10,Z10,A11,B11,C11,D11,W10,E11)]).

input_clause(output_substitution9,axiom,
    [--equal(F11,G11),
     --output(H11,I11,J11,K11,L11,M11,N11,O11,F11),
     ++output(H11,I11,J11,K11,L11,M11,N11,O11,G11)]).

input_clause(test_substitution1,axiom,
    [--equal(P11,Q11),
     --test(P11,R11,S11,T11,U11,V11,W11,X11,Y11,Z11),
     ++test(Q11,R11,S11,T11,U11,V11,W11,X11,Y11,Z11)]).

input_clause(test_substitution2,axiom,
    [--equal(A12,B12),
     --test(C12,A12,D12,E12,F12,G12,H12,I12,J12,K12),
     ++test(C12,B12,D12,E12,F12,G12,H12,I12,J12,K12)]).

input_clause(test_substitution3,axiom,
    [--equal(L12,M12),
     --test(N12,O12,L12,P12,Q12,R12,S12,T12,U12,V12),
     ++test(N12,O12,M12,P12,Q12,R12,S12,T12,U12,V12)]).

input_clause(test_substitution4,axiom,
    [--equal(W12,X12),
     --test(Y12,Z12,A13,W12,B13,C13,D13,E13,F13,G13),
     ++test(Y12,Z12,A13,X12,B13,C13,D13,E13,F13,G13)]).

input_clause(test_substitution5,axiom,
    [--equal(H13,I13),
     --test(J13,K13,L13,M13,H13,N13,O13,P13,Q13,R13),
     ++test(J13,K13,L13,M13,I13,N13,O13,P13,Q13,R13)]).

input_clause(test_substitution6,axiom,
    [--equal(S13,T13),
     --test(U13,V13,W13,X13,Y13,S13,Z13,A14,B14,C14),
     ++test(U13,V13,W13,X13,Y13,T13,Z13,A14,B14,C14)]).

input_clause(test_substitution7,axiom,
    [--equal(D14,E14),
     --test(F14,G14,H14,I14,J14,K14,D14,L14,M14,N14),
     ++test(F14,G14,H14,I14,J14,K14,E14,L14,M14,N14)]).

input_clause(test_substitution8,axiom,
    [--equal(O14,P14),
     --test(Q14,R14,S14,T14,U14,V14,W14,O14,X14,Y14),
     ++test(Q14,R14,S14,T14,U14,V14,W14,P14,X14,Y14)]).

input_clause(test_substitution9,axiom,
    [--equal(Z14,A15),
     --test(B15,C15,D15,E15,F15,G15,H15,I15,Z14,J15),
     ++test(B15,C15,D15,E15,F15,G15,H15,I15,A15,J15)]).

input_clause(test_substitution10,axiom,
    [--equal(K15,L15),
     --test(M15,N15,O15,P15,Q15,R15,S15,T15,U15,K15),
     ++test(M15,N15,O15,P15,Q15,R15,S15,T15,U15,L15)]).

%----Problem axioms
input_clause(add_inverter_definition1,axiom,
    [++equal(add_inverter(list(X,Y),Z),list(X,add_inverter(Y,Z)))]).

input_clause(add_inverter_definition2,axiom,
    [++equal(add_inverter(X,Y),list(Y,X))]).

input_clause(make_reverse_list_definition1,axiom,
    [++equal(make_reverse_list(list(inverter_table(X000,X001,X010,
X011,X100,X101,X110,X111),V)),list_reversion(possible_reversion(
r00m,X000,X001),list_reversion(possible_reversion(r01m,X010,X011),
list_reversion(possible_reversion(r10m,X100,X101),list_reversion(
possible_reversion(r11m,X110,X111),list_reversion(possible_reversion(
r0m0,X000,X010),list_reversion(possible_reversion(r0m1,X001,X011),
list_reversion(possible_reversion(r1m0,X100,X110),list_reversion(
possible_reversion(r1m1,X101,X111),list_reversion(possible_reversion(
rm00,X000,X100),list_reversion(possible_reversion(rm01,X001,X101),
list_reversion(possible_reversion(rm10,X010,X110),list_reversion(
possible_reversion(rm11,X011,X111),make_reverse_list(V))))))))))))))]).

input_clause(make_reverse_list_definition2,axiom,
    [++equal(make_reverse_list(V),end)]).

input_clause(possible_reversion1,axiom,
    [++equal(possible_reversion(Xname,1,0),Xname)]).

input_clause(possible_reversion2,axiom,
    [++equal(possible_reversion(Xname,0,1),not_reversion)]).

input_clause(possible_reversion3,axiom,
    [++equal(possible_reversion(Xname,X,X),not_reversion)]).

input_clause(list_reversion_definition1,axiom,
    [++equal(list_reversion(not_reversion,X),X)]).

input_clause(list_reversion_definition2,axiom,
    [++equal(list_reversion(X,list_reversion(Y,Z)),list_reversion(Y,
list_reversion(X,Z)))]).

input_clause(list_reversion_definition3,axiom,
    [++equal(list_reversion(X,list_reversion(X,Y)),list_reversion(X,Y))]).

input_clause(and_output_definition,axiom,
    [--basic_output(X1,X2,X3,X4,X5,X6,X7,X8,V),
     --basic_output(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,V),
     ++basic_output(and(X1,Y1),and(X2,Y2),and(X3,Y3),and(X4,Y4),and(X5,Y5),
and(X6,Y6),and(X7,Y7),and(X8,Y8),V)]).

input_clause(or_output_definition,axiom,
    [--basic_output(X1,X2,X3,X4,X5,X6,X7,X8,V),
     --output(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,V),
     ++output(or(X1,Y1),or(X2,Y2),or(X3,Y3),or(X4,Y4),or(X5,Y5),
or(X6,Y6),or(X7,Y7),or(X8,Y8),V)]).

input_clause(inverter_test,axiom,
    [--output(X1,X2,X3,X4,X5,X6,X7,X8,V),
     ++test(not(X1),not(X2),not(X3),not(X4),not(X5),not(X6),not(X7),
not(X8),add_inverter(V,inverter_table(not(X1),not(X2),not(X3),not(X4),
not(X5),not(X6),not(X7),not(X8))),make_reverse_list(list(inverter_table(
not(X1),not(X2),not(X3),not(X4),not(X5),not(X6),not(X7),not(X8)),V)))]).

input_clause(basic_output_definition,status,
    [--basic_output(X1,X2,X3,X4,X5,X6,X7,X8,V),
     ++output(X1,X2,X3,X4,X5,X6,X7,X8,V)]).

input_clause(create_test,axiom,
    [--test(X1,X2,X3,X4,X5,X6,X7,X8,V,Xrevlist),
     ++basic_output(X1,X2,X3,X4,X5,X6,X7,X8,V)]).

input_clause(input1,theorem,
    [++output(0,0,0,0,1,1,1,1,X)]).

input_clause(input2,theorem,
    [++output(0,0,1,1,0,0,1,1,X)]).

input_clause(input3,theorem,
    [++output(0,1,0,1,0,1,0,1,X)]).

input_clause(prove_cannot_construct_this,theorem,
    [--output(1,1,1,1,0,0,0,0,V),
     --output(1,1,0,0,1,1,0,0,V),
     --output(1,0,1,0,1,0,1,0,V)]).
%--------------------------------------------------------------------------
