%--------------------------------------------------------------------------
% File     : CID002=Intchg-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Circuit Design
% Problem  : Interchange inputs to outputs
% Version  : 
% English  : Design a circuit with inputs x and y whose outputs are y and 
%            x, and contains no crossings of wires

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated 
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : interchange.ver1.clauses [ANL]

% Status   : 
% Syntax   : Number of clauses           :   58 (   0 non-Horn)(  24 unit)
%            Number of literals          :   96 (  57 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   11 (   3 constant)
%            Number of variables         :  163 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : We represent the circuit built up so far by circuit(top(X), 
%            middle(Y),bottom(Z)), where top and bottom are lists 
%            of outputs, counting outward from the middle.
%          : The original uese the equality clauses as demodulators.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include definitions of AND, OR and NOT 
include('Axioms/CID001-0.ax').
%----Include substitution axioms for AND, OR and NOT 
include('Axioms/CID001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(bottom_substitution1,axiom,
    [--equal(J,K),
     ++equal(bottom(J),bottom(K))]).

input_clause(connect_substitution1,axiom,
    [--equal(L,M),
     ++equal(connect(L,N),connect(M,N))]).

input_clause(connect_substitution2,axiom,
    [--equal(O,P),
     ++equal(connect(Q,O),connect(Q,P))]).

input_clause(middle_substitution1,axiom,
    [--equal(R,S),
     ++equal(middle(R),middle(S))]).

input_clause(table_substitution1,axiom,
    [--equal(B1,C1),
     ++equal(table(B1,D1,E1,F1),table(C1,D1,E1,F1))]).

input_clause(table_substitution2,axiom,
    [--equal(G1,H1),
     ++equal(table(I1,G1,J1,K1),table(I1,H1,J1,K1))]).

input_clause(table_substitution3,axiom,
    [--equal(L1,M1),
     ++equal(table(N1,O1,L1,P1),table(N1,O1,M1,P1))]).

input_clause(table_substitution4,axiom,
    [--equal(Q1,R1),
     ++equal(table(S1,T1,U1,Q1),table(S1,T1,U1,R1))]).

input_clause(top_substitution1,axiom,
    [--equal(V1,W1),
     ++equal(top(V1),top(W1))]).

input_clause(circuit_substitution1,axiom,
    [--equal(X1,Y1),
     --circuit(X1,Z1,A2),
     ++circuit(Y1,Z1,A2)]).

input_clause(circuit_substitution2,axiom,
    [--equal(B2,C2),
     --circuit(D2,B2,E2),
     ++circuit(D2,C2,E2)]).

input_clause(circuit_substitution3,axiom,
    [--equal(F2,G2),
     --circuit(H2,I2,F2),
     ++circuit(H2,I2,G2)]).

%----Problem axioms Split the middle, keeping the middle 
input_clause(split_and_keep_middle1,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(and(Y,X1),X2)),middle(Y),bottom(connect(
and(Y,Z1),Z2)))]).

input_clause(split_and_keep_middle2,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(or(Y,X1),X2)),middle(Y),bottom(connect(
or(Y,Z1),Z2)))]).

%----Split the middle, omitting the middle 
input_clause(split_and_omit_middle1,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(and(Y,X1),X2)),nil,bottom(connect(and(Y,Z1),
Z2)))]).

input_clause(split_and_omit_middle2,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(or(Y,X1),X2)),nil,bottom(connect(or(Y,Z1),
Z2)))]).

%----Join across the middle if it is empty, not keeping the sides 
input_clause(join_across_empty_middle1,axiom,
    [--circuit(top(connect(X1,X2)),nil,bottom(connect(Y1,Y2))),
     ++circuit(top(X2),middle(and(X1,Y1)),bottom(Y2))]).

input_clause(join_across_empty_middle2,axiom,
    [--circuit(top(connect(X1,X2)),nil,bottom(connect(Y1,Y2))),
     ++circuit(top(X2),middle(or(X1,Y1)),bottom(Y2))]).

%----Join across the middle, keeping the sides 
input_clause(join_across_middle1,axiom,
    [--circuit(top(connect(X1,X2)),nil,bottom(connect(Y1,Y2))),
     ++circuit(top(connect(X1,X2)),middle(and(X1,Y1)),bottom(
connect(Y1,Y2)))]).

input_clause(join_across_middle2,axiom,
    [--circuit(top(connect(X1,X2)),nil,bottom(connect(Y1,Y2))),
     ++circuit(top(connect(X1,X2)),middle(or(X1,Y1)),bottom(
connect(Y1,Y2)))]).

%----Join to middle, keeping the sides 
input_clause(join_to_middle1,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(and(Y,X1),connect(X1,X2))),nil,bottom(
connect(and(Y,Z1),connect(Z1,Z2))))]).

input_clause(join_to_middle2,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(or(Y,X1),connect(X1,X2))),nil,bottom(
connect(or(Y,Z1),connect(Z1,Z2))))]).

%----Join the two wires nearest the middle 
input_clause(join_nearest_middle1,axiom,
    [--circuit(top(connect(X1,connect(X2,X3))),middle(Y),bottom(
connect(Z1,connect(Z2,Z3)))),
     ++circuit(top(connect(and(X1,X2),X3)),middle(Y),bottom(connect(
and(Z1,Z2),Z3)))]).

input_clause(join_nearest_middle2,axiom,
    [--circuit(top(connect(X1,connect(X2,X3))),middle(Y),bottom(
connect(Z1,connect(Z2,Z3)))),
     ++circuit(top(connect(or(X1,X2),X3)),middle(Y),bottom(connect(
or(Z1,Z2),Z3)))]).

%----Put inverter on the middle wire 
input_clause(invert_middle,axiom,
    [--circuit(top(X),middle(Y),bottom(Z)),
     ++circuit(top(X),middle(not(Y)),bottom(Z))]).

%----Put inverter on the adjacent wires 
input_clause(invert_adjacent1,axiom,
    [--circuit(top(connect(X1,X2)),middle(Y),bottom(connect(Z1,Z2))),
     ++circuit(top(connect(not(X1),X2)),middle(Y),bottom(connect(
not(Z1),Z2)))]).

input_clause(invert_adjacent2,axiom,
    [--circuit(top(connect(X1,X2)),nil,bottom(connect(Z1,Z2))),
     ++circuit(top(connect(not(X1),X2)),nil,bottom(connect(
not(Z1),Z2)))]).

%----Subsumer to get rid of circuits which are the same on top and bottom 
input_clause(subsume_symmetric,axiom,
    [++circuit(top(X),Y,bottom(X))]).

input_clause(and_table_definition,axiom,
    [++equal(and(table(X1,X2,X3,X4),table(Y1,Y2,Y3,Y4)),
table(and(X1,Y1),and(X2,Y2),and(X3,Y3),and(X4,Y4)))]).

input_clause(and_definition5,axiom,
    [++equal(and(nil,X),X)]).

input_clause(or_table_definition,axiom,
    [++equal(or(table(X1,X2,X3,X4),table(Y1,Y2,Y3,Y4)),
table(or(X1,Y1),or(X2,Y2),or(X3,Y3),or(X4,Y4)))]).

input_clause(or_definition5,axiom,
    [++equal(or(nil,X),X)]).

input_clause(not_table_definition,axiom,
    [++equal(not(table(X1,X2,X3,X4)),
table(not(X1),not(X2),not(X3),not(X4)))]).

input_clause(not_definition3,axiom,
    [++equal(not(nil),nil)]).

input_clause(empty_table,axiom,
    [++equal(table(0,0,0,0),nil)]).

input_clause(full_table,axiom,
    [++equal(table(1,1,1,1),nil)]).

input_clause(connect_definition1,axiom,
    [++equal(connect(nil,X),X)]).

input_clause(connect_definition2,axiom,
    [++equal(connect(X,connect(X,Y)),connect(X,Y))]).

%----Cannot construct the answer 
input_clause(input_configuration,hypothesis,
    [++circuit(top(connect(table(0,0,1,1),nil)),nil,bottom(connect(
table(0,1,0,1),nil)))]).

input_clause(prove_output_configuration,theorem,
    [--circuit(top(connect(table(0,1,0,1),nil)),nil,bottom(connect(
table(0,0,1,1),nil)))]).
%--------------------------------------------------------------------------
