%--------------------------------------------------------------------------
% File     : CID001=OrNand-1 : TPTP v1.1.1. Bugfixed v1.1.1.
% Domain   : Circuit Design
% Problem  : Design an OR gate using NAND gates
% Version  : [Wos, et al., 1992] axioms.
% English  : 

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated 
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : - [Wos, et al., 1992]
%          : design_or.ver1.clauses [ANL]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   9 unit)
%            Number of literals          :   39 (  25 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   52 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : This input file came with no explanation of the 
%            representation.
% Bugfixes : v1.1.1 - Fixed clause in not_substitution1.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(and_substitution1,axiom,
    [--equal(D,E),
     ++equal(and(D,F),and(E,F))]).

input_clause(and_substitution2,axiom,
    [--equal(G,H),
     ++equal(and(I,G),and(I,H))]).

input_clause(nand_substitution1,axiom,
    [--equal(J,K),
     ++equal(nand(J,L),nand(K,L))]).

input_clause(nand_substitution2,axiom,
    [--equal(M,N),
     ++equal(nand(O,M),nand(O,N))]).

input_clause(not_substitution1,axiom,
    [--equal(P,Q),
     ++equal(not(P),not(Q))]).

input_clause(output_substitution1,axiom,
    [--equal(R,S),
     --output(R,T,U,V),
     ++output(S,T,U,V)]).

input_clause(output_substitution2,axiom,
    [--equal(W,X),
     --output(Y,W,Z,A1),
     ++output(Y,X,Z,A1)]).

input_clause(output_substitution3,axiom,
    [--equal(B1,C1),
     --output(D1,E1,B1,F1),
     ++output(D1,E1,C1,F1)]).

input_clause(output_substitution4,axiom,
    [--equal(G1,H1),
     --output(I1,J1,K1,G1),
     ++output(I1,J1,K1,H1)]).

%----Problem axioms 
input_clause(nand_definition,axiom,
    [++equal(nand(X,Y),not(and(X,Y)))]).

input_clause(and_definition1,axiom,
    [++equal(and(X,0),0)]).

input_clause(and_definition2,axiom,
    [++equal(and(X,1),X)]).

input_clause(not_definition1,axiom,
    [++equal(not(0),1)]).

input_clause(not_definition2,axiom,
    [++equal(not(1),0)]).

input_clause(nand_table_definition,theorem,
    [--output(X1,X2,X3,X4),
     --output(Y1,Y2,Y3,Y4),
     ++output(nand(X1,Y1),nand(X2,Y2),nand(X3,Y3),nand(X4,Y4))]).

input_clause(input1,theorem,
    [++output(0,0,1,1)]).

input_clause(input2,theorem,
    [++output(0,1,0,1)]).

input_clause(prove_cannot_make_or,theorem,
    [--output(0,1,1,1)]).
%--------------------------------------------------------------------------
