%--------------------------------------------------------------------------
% File     : CAT019=Indisc-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Axiom of Indiscernibles
% Version  : [Scott, 1979] axioms : Reduced & Augmented > Complete.
% English  : [all z (x=z <-> y=z)] -> x=y.

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(   6 unit)
%            Number of literals          :   52 (  29 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   45 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.
%          : Assumes something exists.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_c_exists,hypothesis,
    [++there_exists(c)]).

input_clause(equality_of_a_and_b1,hypothesis,
    [--there_exists(Z),
     --equal(a,Z),
     ++equal(b,Z)]).

input_clause(equality_of_a_and_b2,hypothesis,
    [--there_exists(Z),
     ++equal(a,Z),
     --equal(b,Z)]).

input_clause(prove_a_equals_b,theorem,
    [--equal(a,b)]).

%----These lemmas are used as demodulators by the ANL group
%input_clause(name,hypothesis,
%    [++equal(domain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(compose(X,Y)),domain(Y))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(compose(X,Y)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(domain(X),domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(codomain(X),codomain(X)),codomain(X))]).
%--------------------------------------------------------------------------
