%--------------------------------------------------------------------------
% File     : CAT019=Indisc-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Axiom of Indiscernibles
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : [all z (x=z <-> y=z)] -> x=y.

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(   5 unit)
%            Number of literals          :   51 (  29 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   45 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.
%          : The ANL set uses very few axioms for this. I'm not sure 
%            if using them all is OK.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
%----Denial of the axiom of indiscernibles 
input_clause(equality_of_a_and_b1,hypothesis,
    [--there_exists(Z),
     --equal(a,Z),
     ++equal(b,Z)]).

input_clause(equality_of_a_and_b2,hypothesis,
    [--there_exists(Z),
     ++equal(a,Z),
     --equal(b,Z)]).

input_clause(prove_a_equals_b,theorem,
    [--equal(a,b)]).
%--------------------------------------------------------------------------
