%--------------------------------------------------------------------------
% File     : CAT019=Indisc-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Axiom of Indiscernibles
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : [all z (x=z <-> y=z)] -> x=y.

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : p15.ver3.no2.in [ANL]
%          : p15.ver3.no4.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   32 (   2 non-Horn)(   5 unit)
%            Number of literals          :   71 (  41 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   63 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : The ANL set uses very few axioms for this. I'm not sure 
%            if using them all is OK.
%          : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT003-0.ax').
include('Axioms/CAT003-0.eq').
%--------------------------------------------------------------------------
%----Denial of the axiom of indiscernibles 
input_clause(equality_of_a_and_b1,hypothesis,
    [--there_exists(Z),
     --equal(a,Z),
     ++equal(b,Z)]).

input_clause(equality_of_a_and_b2,hypothesis,
    [--there_exists(Z),
     ++equal(a,Z),
     --equal(b,Z)]).

input_clause(prove_a_equals_b,theorem,
    [--equal(a,b)]).
%--------------------------------------------------------------------------
