%--------------------------------------------------------------------------
% File     : CAT019=Indisc-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Axiom of Indiscernibles
% Version  : [Quaife, 1989] (equality) axioms.
% English  : [all z (x=z <-> y=z)] -> x=y.

% Refs     : Quaife A. (1989), Email to Larry Wos 05/02/89.
% Source   : [ANL]
% Names    : p15.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(   6 unit)
%            Number of literals          :   30 (  30 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   29 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Quaife's axioms for category theory 
include('Axioms/CAT002-0.ax').
%--------------------------------------------------------------------------
%----c1 and c2 are Skolem functors 
input_clause(equality_to_c1_and_c2_1,hypothesis,
    [--equal(c2,Z),
     ++equal(c1,Z)]).

input_clause(equality_to_c1_and_c2_2,hypothesis,
    [++equal(c2,Z),
     --equal(c1,Z)]).

input_clause(prove_c1_equals_c2,theorem,
    [--equal(c2,c1)]).
%--------------------------------------------------------------------------
