%--------------------------------------------------------------------------
% File     : CAT019=Indisc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Axiom of Indiscernibles
% Version  : [Mitchell, 1967] axioms.
% English  : [all z (x=z <-> y=z)] -> x=y.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
% Source   : [ANL]
% Names    : p15.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(   8 unit)
%            Number of literals          :   82 (  26 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   90 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
%----c1 and c2 are Skolem constants 
input_clause(equality_to_c1_and_c2_1,hypothesis,
    [--equal(c2,Z),
     ++equal(c1,Z)]).

input_clause(equality_to_c1_and_c2_2,hypothesis,
    [++equal(c2,Z),
     --equal(c1,Z)]).

input_clause(prove_c1_equals_c2,theorem,
    [--equal(c2,c1)]).

%----The ANL group use these extra lemmas as demodulators -
%input_clause(name,status
%    [++equal(domain(domain(X)),domain(X))]).
%input_clause(name,status
%    [++equal(codomain(domain(X)),domain(X))]).
%input_clause(name,status
%    [++equal(domain(codomain(X)),codomain(X))]).
%input_clause(name,status
%    [++equal(codomain(codomain(X)),codomain(X))]).
%input_clause(name,status
%    [++equal(compose(codomain(X),X),X)]).
%input_clause(name,status
%    [++equal(compose(X,domain(X)),X)]).
%input_clause(name,status
%    [++equal(compose(codomain(X),codomain(X)),codomain(X))]).
%input_clause(name,status
%    [++equal(compose(domain(X),domain(X)),domain(X))]).
%input_clause(name,status
%    [++equal(domain(compose(X,Y)),domain(Y))]).
%input_clause(name,status
%    [++equal(codomain(compose(X,Y)),codomain(X))]).
%--------------------------------------------------------------------------
