%--------------------------------------------------------------------------
% File     : CAT018=FactEx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : If xy and yz exist, then so does x(yz)
% Version  : [Mitchell, 1967] axioms.
% English  : 

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
% Source   : [ANL]
% Names    : p18.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   80 (  21 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_ab_exists,hypothesis,
    [++defined(a,b)]).

input_clause(assume_bc_exists,hypothesis,
    [++defined(b,c)]).

input_clause(prove_a_bc_exists,theorem,
    [--defined(a,compose(b,c))]).
%--------------------------------------------------------------------------
