%--------------------------------------------------------------------------
% File     : CAT016=DomEx-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : If x exists, then domain(x) exists
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : 

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : p16.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   31 (   2 non-Horn)(   6 unit)
%            Number of literals          :   66 (  36 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   1 constant)
%            Number of variables         :   61 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT003-0.ax').
include('Axioms/CAT003-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_a_exists,hypothesis,
    [++there_exists(a)]).

input_clause(prove_domain_of_a_exists,theorem,
    [--there_exists(domain(a))]).
%--------------------------------------------------------------------------
