%--------------------------------------------------------------------------
% File     : CAT015=Exist-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Prove something exists
% Version  : [Scott, 1979] axioms : Reduced & Augmented > Complete.
% English  : 

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : p15.related.in [ANL]

% Status   : satisfiable
% Syntax   : Number of clauses           :   31 (   3 non-Horn)(   5 unit)
%            Number of literals          :   68 (  37 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   0 constant)
%            Number of variables         :   64 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Can anything be proven to exist, directly from the axioms? 
%            Using all the kinds of resolution steps possible, no.
%          : Axioms simplified by Art Quaife.
%          : Using Quaife's axiom ((x=y) | E(x) | E(y).).
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT003-0.ax').
include('Axioms/CAT003-0.eq').
%--------------------------------------------------------------------------
%----Quaife has this written: (this looks really weird, but results from 
%----having = here stand for equivalence, and it is a strange fact from 
%----Scott's conception that all non-existent things are equivalent.
input_clause(equal_things_exist,axiom,
    [++equal(X,Y),
     ++there_exists(X),
     ++there_exists(Y)]).

%----Denial that anything at all exists 
input_clause(prove_something_exists,theorem,
    [--there_exists(X)]).

%----The ANL group use these lemmas as demodulators
%input_clause(name,hypothesis,
%    [++equal(domain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(compose(X,Y)),domain(Y))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(compose(X,Y)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(domain(X),domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(codomain(X),codomain(X)),codomain(X))]).
%--------------------------------------------------------------------------
