%--------------------------------------------------------------------------
% File     : CAT013=DomOfCod-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : domain(codomain(x)) = codomain(x)
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : 

% Refs     : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(   6 unit)
%            Number of literals          :   46 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   1 constant)
%            Number of variables         :   43 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_codomain_exists,hypothesis,
    [++there_exists(codomain(a))]).

input_clause(prove_domain_of_codomain_is_codomain,theorem,
    [--equal(domain(codomain(a)),codomain(a))]).
%--------------------------------------------------------------------------
