%--------------------------------------------------------------------------
% File     : CAT012=CodOfDom-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : codomain(domain(x)) = domain(x)
% Version  : [Mitchell, 1967] axioms.
% English  : 

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
% Source   : [ANL]
% Names    : p12.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   32 (   0 non-Horn)(   8 unit)
%            Number of literals          :   78 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    4 (   1 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_codomain_of_domain_is_domain,theorem,
    [--equal(codomain(domain(a)),domain(a))]).
%--------------------------------------------------------------------------
